/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.options;

import java.io.Serializable;
import org.crosswire.common.util.Convert;

public abstract class DataType
implements Serializable {
    public static final DataType STRING;
    public static final DataType INTEGER;
    public static final DataType BOOLEAN;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final DataType[] VALUES;
    private static final long serialVersionUID = 3256727260177708345L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected DataType(String name) {
        this.name = name;
    }

    public abstract Object convertFromString(String var1);

    public static DataType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            DataType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static DataType fromInteger(int i) {
        return VALUES[i];
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !DataType.class.desiredAssertionStatus();
        STRING = new DataType("String"){
            private static final long serialVersionUID = -2521783846509171308L;

            public Object convertFromString(String value) {
                return value;
            }
        };
        INTEGER = new DataType("Integer"){
            private static final long serialVersionUID = -2521783846509171308L;

            public Object convertFromString(String value) {
                return new Integer(Convert.string2Int(value));
            }
        };
        BOOLEAN = new DataType("Boolean"){
            private static final long serialVersionUID = -2521783846509171308L;

            public Object convertFromString(String value) {
                return Convert.string2Boolean(value);
            }
        };
        VALUES = new DataType[0];
    }
}

