/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Font;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;

public class FontStore {
    private static final String DEFAULT_FONT = "Dialog-PLAIN-12";
    private String storeName;
    private String defaultFont;
    private URI fontStore;
    private boolean loaded;
    private Properties fontMap;
    private static final String LANG_KEY_PREFIX = "lang.";
    private static final String DEFAULT_KEY = "default";
    private static final Logger log = Logger.getLogger((Class)FontStore.class);

    public FontStore(String storeName, URI fontDir) {
        if (fontDir == null) {
            throw new IllegalArgumentException("fontStore cannot be null");
        }
        this.storeName = storeName;
        this.fontStore = NetUtil.lengthenURI((URI)fontDir, (String)(this.storeName + ".properties"));
        this.fontMap = new Properties();
    }

    public String getDefaultFont() {
        this.load();
        this.defaultFont = this.fontMap.getProperty(DEFAULT_KEY, DEFAULT_FONT);
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.load();
        this.defaultFont = defaultFont;
        this.fontMap.setProperty(DEFAULT_KEY, defaultFont);
        this.store();
    }

    public void setFont(String resource, Font font) {
        if (resource == null || font == null) {
            return;
        }
        this.load();
        this.fontMap.setProperty(resource, GuiConvert.font2String(font));
        this.store();
    }

    public void setFont(Language lang, Font font) {
        if (lang == null || font == null) {
            return;
        }
        this.load();
        this.fontMap.setProperty(LANG_KEY_PREFIX + lang.getCode(), GuiConvert.font2String(font));
        this.store();
    }

    public Font getFont(String resource, Language lang, String fallback) {
        Font obtainedFont;
        this.load();
        String fontSpec = null;
        if (resource != null) {
            fontSpec = this.fontMap.getProperty(resource);
        }
        if (fontSpec != null) {
            obtainedFont = this.obtainFont(fontSpec);
            if (obtainedFont != null) {
                return obtainedFont;
            }
            fontSpec = null;
        }
        if (lang != null) {
            fontSpec = this.fontMap.getProperty(LANG_KEY_PREFIX + lang.getCode());
        }
        if (fontSpec != null && (obtainedFont = this.obtainFont(fontSpec)) != null) {
            return obtainedFont;
        }
        fontSpec = fallback;
        if (fontSpec != null && (obtainedFont = this.obtainFont(fontSpec)) != null) {
            return obtainedFont;
        }
        return GuiConvert.string2Font(this.defaultFont);
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        try {
            this.fontMap = ResourceUtil.getProperties((String)this.storeName);
            this.loaded = true;
        }
        catch (IOException e) {
            log.error("Unable to load the font store: " + this.fontStore);
            this.fontMap = new Properties();
        }
    }

    private void store() {
        this.load();
        try {
            NetUtil.storeProperties((Properties)this.fontMap, (URI)this.fontStore, (String)this.storeName);
        }
        catch (IOException ex) {
            log.error("Failed to save BibleDesktop UI Translation", (Throwable)ex);
        }
    }

    private Font obtainFont(String fontSpec) {
        Font obtainedFont;
        String obtainedFontSpec;
        if (fontSpec != null && (obtainedFontSpec = GuiConvert.font2String(obtainedFont = GuiConvert.string2Font(fontSpec))) != null && obtainedFontSpec.equalsIgnoreCase(fontSpec)) {
            return obtainedFont;
        }
        return null;
    }
}

