/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Countries;
import org.crosswire.common.util.Languages;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.StringUtil;

public class Translations {
    private static final String TRANSLATION_KEY = "translation-codes";
    public static final String DEFAULT_TRANSLATION = "en";
    private String translation = "en";
    private String[] translations;
    private static Translations instance = new Translations();
    private static final Logger log = Logger.getLogger(Translations.class);

    private Translations() {
        try {
            Properties props = ResourceUtil.getProperties(this.getClass());
            this.translation = props.getProperty(TRANSLATION_KEY, DEFAULT_TRANSLATION);
        }
        catch (IOException e) {
            this.translation = DEFAULT_TRANSLATION;
        }
    }

    public static Translations instance() {
        return instance;
    }

    public Map getSupported() {
        this.loadSupportedTranslations();
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.translations.length; ++i) {
            names.put(this.translations[i], this.toString(this.translations[i]));
        }
        return names;
    }

    public Locale getCurrentLocale() {
        if (this.translation.indexOf(95) != -1) {
            String[] locale = StringUtil.split(this.translation, '_');
            return new Locale(locale[0], locale[1]);
        }
        return new Locale(this.translation);
    }

    public String getCurrent() {
        return this.toString(this.translation);
    }

    public void setCurrent(String newTranslation) {
        String found = DEFAULT_TRANSLATION;
        String currentTranslation = "";
        for (int i = 0; i < this.translations.length; ++i) {
            String trans = this.translations[i];
            currentTranslation = this.toString(this.translation);
            if (!trans.equals(newTranslation) && !currentTranslation.equals(newTranslation)) continue;
            found = trans;
            break;
        }
        try {
            this.translation = found;
            Properties props = new Properties();
            props.put(TRANSLATION_KEY, this.translation);
            URI outputURI = CWProject.instance().getWritablePropertiesURI(this.getClass().getName());
            NetUtil.storeProperties(props, outputURI, "BibleDesktop UI Translation");
        }
        catch (IOException ex) {
            log.error("Failed to save BibleDesktop UI Translation", ex);
        }
    }

    public void setLocale() {
        Locale.setDefault(this.getCurrentLocale());
    }

    public void register() {
        ChoiceFactory.getDataMap().put(TRANSLATION_KEY, Translations.getSupportedTranslations());
    }

    public static String getCurrentTranslation() {
        return Translations.instance().getCurrent();
    }

    public static void setCurrentTranslation(String newTranslation) {
        Translations.instance().setCurrent(newTranslation);
    }

    public static Map getSupportedTranslations() {
        return Translations.instance().getSupported();
    }

    private void loadSupportedTranslations() {
        if (this.translations == null) {
            try {
                URL index = ResourceUtil.getResource(Translations.class, "translations.txt");
                this.translations = NetUtil.listByIndexFile(NetUtil.toURI(index));
            }
            catch (IOException ex) {
                this.translations = new String[0];
            }
        }
    }

    public String toString(String translationCode) {
        StringBuffer currentTranslation = new StringBuffer(Languages.getLanguageName(translationCode));
        if (translationCode.indexOf(95) != -1) {
            String[] locale = StringUtil.split(translationCode, '_');
            currentTranslation.append(", ");
            currentTranslation.append(Countries.getCountry(locale[1]));
        }
        return currentTranslation.toString();
    }
}

