/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.StringUtil;

public class Countries {
    public static final String DEFAULT_COUNTRY_CODE = "US";
    private static final String UNKNOWN_COUNTRY_CODE = "XX";
    private static ResourceBundle countries;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Countries() {
    }

    public static boolean isValidCountry(String iso3166Code) {
        String lookup = iso3166Code;
        if (lookup == null || lookup.length() == 0) {
            return true;
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Countries.isValidCountry(locale[1]);
        }
        if (lookup.length() > 2) {
            return false;
        }
        try {
            countries.getString(lookup);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getCountry(String iso3166Code) {
        String lookup = iso3166Code;
        if (lookup == null || lookup.length() == 0) {
            return Countries.getCountry(DEFAULT_COUNTRY_CODE);
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Countries.getCountry(locale[1]);
        }
        try {
            return countries.getString(lookup);
        }
        catch (MissingResourceException e) {
            return Countries.getCountry(UNKNOWN_COUNTRY_CODE);
        }
    }

    static {
        block2: {
            $assertionsDisabled = !Countries.class.desiredAssertionStatus();
            try {
                countries = ResourceBundle.getBundle("iso3166", Locale.getDefault(), CWClassLoader.instance());
            }
            catch (MissingResourceException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

