/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.diff.Diff;
import org.crosswire.common.diff.DiffCleanup;
import org.crosswire.common.util.Language;
import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookProvider;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.passage.Key;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

public class BookData
implements BookProvider {
    private Key key;
    private Book[] books;
    private boolean comparingBooks;
    private Element osis;
    private Element fragment;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BookData(Book book, Key key) {
        if (!$assertionsDisabled && book == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        this.key = key;
        this.books = new Book[1];
        this.books[0] = book;
    }

    public BookData(Book[] books, Key key, boolean compare) {
        if (!($assertionsDisabled || books != null && books.length > 0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        this.books = (Book[])books.clone();
        this.key = key;
        this.comparingBooks = compare;
    }

    public Element getOsis() throws BookException {
        if (this.osis == null) {
            this.osis = OSISUtil.createOsisFramework(this.getFirstBook().getBookMetaData());
            Element text = this.osis.getChild("osisText");
            Element div = this.getOsisFragment();
            text.addContent((Content)div);
        }
        return this.osis;
    }

    public Element getOsisFragment() throws BookException {
        if (this.fragment == null) {
            this.fragment = this.getOsisContent();
        }
        return this.fragment;
    }

    public SAXEventProvider getSAXEventProvider() throws BookException {
        Element frag = this.getOsisFragment();
        Document doc = frag.getDocument();
        if (doc == null) {
            doc = new Document(frag);
        }
        return new JDOMSAXEventProvider(doc);
    }

    public Book[] getBooks() {
        return this.books == null ? null : (Book[])this.books.clone();
    }

    public Book getFirstBook() {
        return this.books != null && this.books.length > 0 ? this.books[0] : null;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isComparingBooks() {
        return this.comparingBooks;
    }

    private Element getOsisContent() throws BookException {
        Element div = OSISUtil.factory().createDiv();
        if (this.books.length == 1) {
            Iterator iter = this.books[0].getOsisIterator(this.key, false);
            while (iter.hasNext()) {
                Content content = (Content)iter.next();
                div.addContent(content);
            }
        } else {
            Element table = OSISUtil.factory().createTable();
            Element row = OSISUtil.factory().createRow();
            Element cell = null;
            table.addContent((Content)row);
            Iterator[] iters = new Iterator[this.books.length];
            boolean[] showDiffs = new boolean[this.books.length - 1];
            boolean doDiffs = false;
            for (int i = 0; i < this.books.length; ++i) {
                Book book = this.books[i];
                cell = OSISUtil.factory().createHeaderCell();
                if (i > 0) {
                    Book prevBook = this.books[i - 1];
                    BookCategory category = book.getBookCategory();
                    BookCategory prevCategory = prevBook.getBookCategory();
                    String prevName = prevBook.getInitials();
                    boolean bl = showDiffs[i - 1] = this.comparingBooks && BookCategory.BIBLE.equals(category) && category.equals(prevCategory) && book.getLanguage().equals((Object)prevBook.getLanguage()) && !book.getInitials().equals(prevName);
                    if (showDiffs[i - 1]) {
                        doDiffs = true;
                        StringBuffer buf = new StringBuffer(prevBook.getInitials());
                        buf.append(" ==> ");
                        buf.append(book.getInitials());
                        cell.addContent((Content)OSISUtil.factory().createText(buf.toString()));
                        row.addContent((Content)cell);
                        cell = OSISUtil.factory().createHeaderCell();
                    }
                }
                cell.addContent((Content)OSISUtil.factory().createText(book.getInitials()));
                row.addContent((Content)cell);
                iters[i] = book.getOsisIterator(this.key, true);
            }
            Content content = null;
            int cellCount = 0;
            int rowCount = 0;
            while (true) {
                cellCount = 0;
                row = OSISUtil.factory().createRow();
                String lastText = "";
                for (int i = 0; i < iters.length; ++i) {
                    Book book = this.books[i];
                    cell = OSISUtil.factory().createCell();
                    Language lang = (Language)book.getProperty("Lang");
                    cell.setAttribute("lang", lang.getCode(), Namespace.XML_NAMESPACE);
                    row.addContent((Content)cell);
                    if (!iters[i].hasNext()) continue;
                    content = (Content)iters[i].next();
                    if (doDiffs) {
                        String thisText = "";
                        if (content instanceof Element) {
                            thisText = OSISUtil.getCanonicalText((Element)content);
                        } else if (content instanceof Text) {
                            thisText = ((Text)content).getText();
                        }
                        if (i > 0 && showDiffs[i - 1]) {
                            List diffs = new Diff(lastText, thisText, false).compare();
                            DiffCleanup.cleanupSemantic((List)diffs);
                            cell.addContent((Collection)OSISUtil.diffToOsis(diffs));
                            cell = OSISUtil.factory().createCell();
                            lang = (Language)book.getProperty("Lang");
                            cell.setAttribute("lang", lang.getCode(), Namespace.XML_NAMESPACE);
                            row.addContent((Content)cell);
                        }
                        lastText = thisText;
                    }
                    cell.addContent(content);
                    ++cellCount;
                }
                if (cellCount == 0) break;
                table.addContent((Content)row);
                ++rowCount;
            }
            if (rowCount > 0) {
                div.addContent((Content)table);
            }
        }
        return div;
    }

    static {
        $assertionsDisabled = !BookData.class.desiredAssertionStatus();
    }
}

