/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.search;

import java.io.Serializable;
import org.crosswire.jsword.index.query.QueryDecorator;
import org.crosswire.jsword.index.query.QueryDecoratorFactory;

public abstract class SearchType
implements Serializable {
    public static final SearchType PHRASE = new SearchType("Phrase"){
        private static final long serialVersionUID = 4049921554181534256L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decoratePhrase(queryWords);
        }
    };
    public static final SearchType ALL_WORDS = new SearchType("All"){
        private static final long serialVersionUID = 3256721771208980279L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateAllWords(queryWords);
        }
    };
    public static final SearchType ANY_WORDS = new SearchType("Any"){
        private static final long serialVersionUID = 3257846580244853043L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateAnyWords(queryWords);
        }
    };
    public static final SearchType NOT_WORDS = new SearchType("Not"){
        private static final long serialVersionUID = 4050480123318842929L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateNotWords(queryWords);
        }
    };
    public static final SearchType START_WORDS = new SearchType("Start"){
        private static final long serialVersionUID = 3544667378161168437L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateStartWords(queryWords);
        }
    };
    public static final SearchType SPELL_WORDS = new SearchType("Spell"){
        private static final long serialVersionUID = 3544387006957237044L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateSpellWords(queryWords);
        }
    };
    public static final SearchType RANGE = new SearchType("Range"){
        private static final long serialVersionUID = 3257288028421959989L;

        public String decorate(String queryWords) {
            return SEARCH_SYNTAX.decorateRange(queryWords);
        }
    };
    private String name;
    protected static final QueryDecorator SEARCH_SYNTAX = QueryDecoratorFactory.getSearchSyntax();
    private static int nextObj;
    private final int obj = nextObj++;
    private static final SearchType[] VALUES;
    private static final long serialVersionUID = 3256721767014871089L;

    protected SearchType(String name) {
        this.name = name;
    }

    public abstract String decorate(String var1);

    public static SearchType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            SearchType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        throw new ClassCastException("Not a valid search type");
    }

    public static SearchType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new SearchType[]{PHRASE, ALL_WORDS, ANY_WORDS, NOT_WORDS, START_WORDS, SPELL_WORDS, RANGE};
    }
}

