/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.util.Properties;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.index.lucene.analysis.AbstractAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SimpleLuceneAnalyzer;

public class AnalyzerFactory {
    public static final String DEFAULT_ID = "Default";
    private static final Logger log = Logger.getLogger((Class)AnalyzerFactory.class);
    private static AnalyzerFactory myInstance;
    private Properties myProperties;

    public AbstractAnalyzer createAnalyzer(String lang) {
        AbstractAnalyzer newObject = null;
        if (lang != null) {
            String adjustLang = lang;
            if (adjustLang.startsWith("Greek, Modern")) {
                adjustLang = "Greek";
            }
            String aClass = this.getAnalyzerValue(adjustLang);
            log.debug("Creating analyzer:" + aClass + " BookLang:" + adjustLang);
            if (aClass != null) {
                try {
                    Class impl = ClassUtil.forName((String)aClass);
                    newObject = (AbstractAnalyzer)((Object)impl.newInstance());
                }
                catch (ClassNotFoundException e) {
                    log.error("Configuration error in AnalyzerFactory properties", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error("Configuration error in AnalyzerFactory properties", (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error("Configuration error in AnalyzerFactory properties", (Throwable)e);
                }
            }
        }
        if (newObject == null) {
            newObject = new SimpleLuceneAnalyzer();
        }
        newObject.setDoStemming(this.getDefaultStemmingProperty());
        newObject.setDoStopWords(this.getDefaultStopWordProperty());
        newObject.setNaturalLanguage(lang);
        return newObject;
    }

    public static AnalyzerFactory getInstance() {
        if (myInstance == null) {
            myInstance = new AnalyzerFactory();
        }
        return myInstance;
    }

    private AnalyzerFactory() {
        this.loadProperties();
    }

    public String getAnalyzerValue(String lang) {
        String key = lang + ".Analyzer";
        return this.myProperties.getProperty(key);
    }

    public boolean getDefaultStemmingProperty() {
        String key = "Default.Stemming";
        return Boolean.valueOf(this.myProperties.getProperty(key));
    }

    public boolean getDefaultStopWordProperty() {
        String key = "Default.StopWord";
        return Boolean.valueOf(this.myProperties.getProperty(key));
    }

    private void loadProperties() {
        try {
            this.myProperties = ResourceUtil.getProperties(this.getClass());
        }
        catch (IOException e) {
            log.error("AnalyzerFactory property load from file failed", (Throwable)e);
        }
    }
}

