/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import java.util.Iterator;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.versification.BibleInfo;

public class BibleScope {
    private Book book;
    private Key inScope;
    private Key outScope;

    public BibleScope(Book book) {
        this.book = book;
    }

    public Key getInScope() {
        this.computeScope();
        return this.inScope;
    }

    public Key getOutOfScope() {
        this.computeScope();
        return this.outScope;
    }

    private void computeScope() {
        if (this.inScope == null) {
            KeyFactory keyf = PassageKeyFactory.instance();
            Key all = keyf.getGlobalKeyList();
            this.inScope = keyf.createEmptyKeyList();
            this.outScope = keyf.createEmptyKeyList();
            Iterator iter = all.iterator();
            while (iter.hasNext()) {
                Key key = (Key)iter.next();
                if (this.book.contains(key)) {
                    this.inScope.addAll(key);
                    continue;
                }
                this.outScope.addAll(key);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            BibleScope.usage();
        }
        System.err.println("BibleScope " + args[0]);
        Book b = Books.installed().getBook(args[0]);
        if (b == null) {
            System.err.println("Book not found");
            System.exit(1);
        }
        if (!b.getBookCategory().equals(BookCategory.BIBLE)) {
            System.err.println(b.getInitials() + " is not a Bible");
            System.exit(1);
        }
        BibleScope scope = new BibleScope(b);
        BibleInfo.setFullBookName(false);
        System.out.println("Scope of KJV versification for " + b.getInitials());
        System.out.println("In scope     = " + scope.getInScope().getName());
        System.out.println("Out of scope = " + scope.getOutOfScope().getName());
    }

    public static void usage() {
        System.err.println("Usage: BibleScope book");
        System.exit(1);
    }
}

