/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.compress.CompressorType;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.DataEntry;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.RawLDBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.UserMsg;

public class ZLDBackend
extends RawLDBackend {
    private static final String EXTENSION_Z_INDEX = ".zdx";
    private static final String EXTENSION_Z_DATA = ".zdt";
    private static final int ZDX_ENTRY_SIZE = 8;
    private static final int BLOCK_ENTRY_COUNT = 4;
    private static final int BLOCK_ENTRY_SIZE = 8;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private boolean active;
    private File zdxFile;
    private RandomAccessFile zdxRaf;
    private File zdtFile;
    private RandomAccessFile zdtRaf;
    private long lastBlockNum = -1L;
    private byte[] lastUncompressed = EMPTY_BYTES;
    private static final long serialVersionUID = 3536098410391064446L;
    private static final Logger log = Logger.getLogger((Class)ZLDBackend.class);

    public ZLDBackend(SwordBookMetaData sbmd) {
        super(sbmd, 4);
    }

    protected String getRawText(DataEntry entry) {
        DataIndex blockIndex = entry.getBlockIndex();
        long blockNum = blockIndex.getOffset();
        int blockEntry = blockIndex.getSize();
        byte[] uncompressed = null;
        if (blockNum == this.lastBlockNum) {
            uncompressed = this.lastUncompressed;
        } else {
            try {
                byte[] temp = SwordUtil.readRAF(this.zdxRaf, blockNum * 8L, 8);
                if (temp == null || temp.length == 0) {
                    return "";
                }
                int blockStart = SwordUtil.decodeLittleEndian32(temp, 0);
                int blockSize = SwordUtil.decodeLittleEndian32(temp, 4);
                temp = SwordUtil.readRAF(this.zdtRaf, blockStart, blockSize);
                this.decipher(temp);
                String compressType = (String)this.getBookMetaData().getProperty(ConfigEntryType.COMPRESS_TYPE);
                uncompressed = CompressorType.fromString((String)compressType).getCompressor(temp).uncompress().toByteArray();
                this.lastBlockNum = blockNum;
                this.lastUncompressed = uncompressed;
            }
            catch (IOException e) {
                return "";
            }
        }
        int entryCount = SwordUtil.decodeLittleEndian32(uncompressed, 0);
        if (blockEntry >= entryCount) {
            return "";
        }
        int entryOffset = 4 + 8 * blockEntry;
        int entryStart = SwordUtil.decodeLittleEndian32(uncompressed, entryOffset);
        int entrySize = SwordUtil.decodeLittleEndian32(uncompressed, entryOffset + 4);
        byte[] entryBytes = new byte[entrySize];
        System.arraycopy(uncompressed, entryStart, entryBytes, 0, entrySize);
        return SwordUtil.decode(entry.getName(), entryBytes, this.getBookMetaData().getBookCharset()).trim();
    }

    public void activate(Lock lock) {
        super.activate(lock);
        this.active = false;
        this.zdxFile = null;
        this.zdtFile = null;
        this.zdxRaf = null;
        this.zdtRaf = null;
        this.lastBlockNum = -1L;
        this.lastUncompressed = EMPTY_BYTES;
        URI path = null;
        try {
            path = this.getExpandedDataPath();
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
            return;
        }
        try {
            this.zdxFile = new File(path.getPath() + EXTENSION_Z_INDEX);
            this.zdtFile = new File(path.getPath() + EXTENSION_Z_DATA);
            if (!this.zdxFile.canRead()) {
                Reporter.informUser((Object)this, (LucidException)new BookException((MsgBase)UserMsg.READ_FAIL, new Object[]{this.zdtFile.getAbsolutePath()}));
                return;
            }
            if (!this.zdtFile.canRead()) {
                Reporter.informUser((Object)this, (LucidException)new BookException((MsgBase)UserMsg.READ_FAIL, new Object[]{this.zdtFile.getAbsolutePath()}));
                return;
            }
            this.zdxRaf = new RandomAccessFile(this.zdxFile, "r");
            this.zdtRaf = new RandomAccessFile(this.zdtFile, "r");
        }
        catch (IOException ex) {
            log.error("failed to open files", (Throwable)ex);
            this.zdxRaf = null;
            this.zdtRaf = null;
            return;
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(Lock lock) {
        super.deactivate(lock);
        this.lastBlockNum = -1L;
        this.lastUncompressed = EMPTY_BYTES;
        try {
            if (this.zdxRaf != null) {
                this.zdxRaf.close();
            }
            if (this.zdtRaf != null) {
                this.zdtRaf.close();
            }
        }
        catch (IOException ex) {
            log.error("failed to close files", (Throwable)ex);
        }
        finally {
            this.zdxRaf = null;
            this.zdtRaf = null;
        }
        this.active = false;
    }

    protected boolean isActive() {
        return this.active && super.isActive();
    }
}

