/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.filter.FilterException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.AbstractKeyBackend;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.DefaultLeafKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.jdom.Element;

public class SwordDictionary
extends AbstractBook {
    private boolean active;
    private AbstractKeyBackend backend;
    private SwordBookMetaData sbmd;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected SwordDictionary(SwordBookMetaData sbmd, AbstractBackend backend) {
        super(sbmd);
        this.sbmd = sbmd;
        this.backend = (AbstractKeyBackend)backend;
        this.active = false;
    }

    public Iterator getOsisIterator(Key key, boolean allowEmpty) throws BookException {
        this.checkActive();
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.backend == null) {
            throw new AssertionError();
        }
        try {
            ArrayList<Element> content = new ArrayList<Element>();
            Element title = OSISUtil.factory().createTitle();
            title.addContent(key.getName());
            content.add(title);
            String txt = this.backend.getRawText(key);
            List osisContent = this.sbmd.getFilter().toOSIS(this, key, txt);
            content.addAll(osisContent);
            return content.iterator();
        }
        catch (FilterException ex) {
            throw new BookException((MsgBase)Msg.FILTER_FAIL, (Throwable)((Object)ex));
        }
    }

    public boolean contains(Key key) {
        return this.backend != null && this.backend.contains(key);
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.backend == null) {
            throw new AssertionError();
        }
        return this.backend.getRawText(key);
    }

    public boolean isWritable() {
        return this.backend.isWritable();
    }

    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    public Key getGlobalKeyList() {
        this.checkActive();
        return this.backend;
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String text) throws NoSuchKeyException {
        this.checkActive();
        int pos = this.backend.indexOf(new DefaultLeafKeyList(text));
        if (pos < 0) {
            if (this.backend.getCardinality() > -pos - 1) {
                return this.backend.get(-pos - 1);
            }
            return this.backend.get(this.backend.getCardinality() - 1);
        }
        return this.backend.get(pos);
    }

    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    public final void activate(Lock lock) {
        super.activate(lock);
        this.active = true;
    }

    public final void deactivate(Lock lock) {
        super.deactivate(lock);
        Activator.deactivate((Activatable)this.backend);
        this.active = false;
    }

    private void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    static {
        $assertionsDisabled = !SwordDictionary.class.desiredAssertionStatus();
    }
}

