/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Iterable;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.basic.AbstractBookList;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.sword.HttpSwordInstaller;
import org.crosswire.jsword.book.install.sword.Msg;
import org.crosswire.jsword.book.install.sword.UserMsg;
import org.crosswire.jsword.book.sword.ConfigEntry;
import org.crosswire.jsword.book.sword.SwordBook;
import org.crosswire.jsword.book.sword.SwordBookDriver;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordBookPath;

public abstract class AbstractSwordInstaller
extends AbstractBookList
implements Installer,
Comparable {
    protected Map entries = new HashMap();
    protected String host;
    protected String proxyHost;
    protected Integer proxyPort;
    protected String packageDirectory = "";
    protected String catalogDirectory = "";
    protected String indexDirectory = "";
    protected boolean loaded;
    protected static final String FILE_LIST_GZ = "mods.d.tar.gz";
    protected static final String ZIP_SUFFIX = ".zip";
    private static final Logger log = Logger.getLogger((Class)AbstractSwordInstaller.class);
    protected static final String SEARCH_DIR = "search/jsword/L1";
    protected static final String DOWNLOAD_PREFIX = "download-";

    protected abstract void download(Progress var1, String var2, String var3, URI var4) throws InstallException;

    public String getInstallerDefinition() {
        StringBuffer buf = new StringBuffer(this.host);
        buf.append(',');
        buf.append(this.packageDirectory);
        buf.append(',');
        buf.append(this.catalogDirectory);
        buf.append(',');
        buf.append(this.indexDirectory);
        buf.append(',');
        if (this.proxyHost != null) {
            buf.append(this.proxyHost);
        }
        buf.append(',');
        if (this.proxyPort != null) {
            buf.append(this.proxyPort);
        }
        return buf.toString();
    }

    public boolean isNewer(Book book) {
        SwordBookMetaData sbmd;
        File dldir = SwordBookPath.getSwordDownloadDir();
        File conf = new File(dldir, (sbmd = (SwordBookMetaData)book.getBookMetaData()).getConfPath());
        if (!conf.exists()) {
            return false;
        }
        URI configURI = NetUtil.getURI((File)conf);
        URI remote = this.toRemoteURI(book);
        return NetUtil.isNewer((URI)remote, (URI)configURI, (String)this.proxyHost, (Integer)this.proxyPort);
    }

    public List getBooks() {
        try {
            if (!this.loaded) {
                this.loadCachedIndex();
            }
            return new ArrayList(this.entries.values());
        }
        catch (InstallException ex) {
            log.error("Failed to reload cached index file", (Throwable)((Object)ex));
            return new ArrayList();
        }
    }

    public synchronized Book getBook(String name) {
        Book book;
        List books = this.getBooks();
        Iterator iter = books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            if (!name.equals(book.getName())) continue;
            return book;
        }
        iter = books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            if (!name.equalsIgnoreCase(book.getName())) continue;
            return book;
        }
        iter = books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            BookMetaData bmd = book.getBookMetaData();
            if (!name.equals(bmd.getInitials())) continue;
            return book;
        }
        iter = books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            if (!name.equalsIgnoreCase(book.getInitials())) continue;
            return book;
        }
        return null;
    }

    public synchronized List getBooks(BookFilter filter) {
        List temp = CollectionUtil.createList((Iterable)new BookFilterIterator(this.getBooks(), filter));
        return new BookSet((Collection)temp);
    }

    public void install(Book book) {
        if (Books.installed().getBook(book.getName()) != null) {
            return;
        }
        final SwordBookMetaData sbmd = (SwordBookMetaData)book.getBookMetaData();
        Thread worker = new Thread("DisplayPreLoader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                URI predictURI = CWProject.instance().getWritablePropertiesURI("sword-install");
                Progress job = JobManager.createJob((String)UserMsg.INSTALLING.toString(sbmd.getName()), (URI)predictURI, (Thread)this, (boolean)true);
                1.yield();
                try {
                    job.setSectionName(UserMsg.JOB_INIT.toString());
                    URI temp = NetUtil.getTemporaryURI((String)"swd", (String)AbstractSwordInstaller.ZIP_SUFFIX);
                    AbstractSwordInstaller.this.download(job, AbstractSwordInstaller.this.packageDirectory, sbmd.getInitials() + AbstractSwordInstaller.ZIP_SUFFIX, temp);
                    job.setCancelable(false);
                    if (!job.isFinished()) {
                        File dldir = SwordBookPath.getSwordDownloadDir();
                        IOUtil.unpackZip((File)NetUtil.getAsFile((URI)temp), (File)dldir);
                        job.setSectionName(UserMsg.JOB_CONFIG.toString());
                        sbmd.setLibrary(NetUtil.getURI((File)dldir));
                        SwordBookDriver.registerNewBook(sbmd);
                    }
                }
                catch (IOException e) {
                    Reporter.informUser((Object)this, (Throwable)e);
                    job.cancel();
                }
                catch (InstallException e) {
                    Reporter.informUser((Object)this, (LucidException)e);
                    job.cancel();
                }
                catch (BookException e) {
                    Reporter.informUser((Object)this, (LucidException)e);
                    job.cancel();
                }
                finally {
                    job.done();
                }
            }
        };
        worker.setPriority(1);
        worker.start();
    }

    public void reloadBookList() throws InstallException {
        Progress job = JobManager.createJob((String)UserMsg.JOB_DOWNLOADING.toString(), (Thread)Thread.currentThread(), (boolean)false);
        try {
            URI scratchfile = this.getCachedIndexFile();
            this.download(job, this.catalogDirectory, FILE_LIST_GZ, scratchfile);
            this.loaded = false;
        }
        catch (InstallException ex) {
            job.cancel();
            throw ex;
        }
        finally {
            job.done();
        }
    }

    public void downloadSearchIndex(Book book, URI localDest) throws InstallException {
        Progress job = JobManager.createJob((String)UserMsg.JOB_DOWNLOADING.toString(), (Thread)Thread.currentThread(), (boolean)false);
        try {
            this.download(job, this.packageDirectory + '/' + SEARCH_DIR, book.getInitials() + ZIP_SUFFIX, localDest);
        }
        catch (InstallException ex) {
            job.cancel();
            throw ex;
        }
        finally {
            job.done();
        }
    }

    private void loadCachedIndex() throws InstallException {
        BookDriver fake = SwordBookDriver.instance();
        this.entries.clear();
        URI cache = this.getCachedIndexFile();
        if (!NetUtil.isFile((URI)cache)) {
            this.reloadBookList();
        }
        InputStream in = null;
        GZIPInputStream gin = null;
        TarInputStream tin = null;
        try {
            TarEntry entry;
            ConfigEntry.resetStatistics();
            in = NetUtil.getInputStream((URI)cache);
            gin = new GZIPInputStream(in);
            tin = new TarInputStream((InputStream)gin);
            while ((entry = tin.getNextEntry()) != null) {
                String internal = entry.getName();
                if (entry.isDirectory()) continue;
                try {
                    int size = (int)entry.getSize();
                    if (size == 0) {
                        log.error("Empty entry: " + internal);
                        continue;
                    }
                    byte[] buffer = new byte[size];
                    if (tin.read(buffer) != size) {
                        log.error("Did not read all that was expected " + internal);
                        continue;
                    }
                    if (internal.endsWith(".conf")) {
                        internal = internal.substring(0, internal.length() - 5);
                    }
                    if (internal.startsWith("mods.d/")) {
                        internal = internal.substring(7);
                    }
                    SwordBookMetaData sbmd = new SwordBookMetaData(buffer, internal);
                    sbmd.setDriver(fake);
                    SwordBook book = new SwordBook(sbmd, null);
                    this.entries.put(book.getName(), book);
                }
                catch (IOException ex) {
                    log.error("Failed to load config for entry: " + internal, (Throwable)ex);
                }
            }
            this.loaded = true;
            ConfigEntry.dumpStatistics();
        }
        catch (IOException ex) {
            try {
                throw new InstallException((MsgBase)Msg.CACHE_ERROR, ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(tin);
                IOUtil.close(gin);
                IOUtil.close((InputStream)in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)tin);
        IOUtil.close((InputStream)gin);
        IOUtil.close((InputStream)in);
    }

    public String getCatalogDirectory() {
        return this.catalogDirectory;
    }

    public void setCatalogDirectory(String catologDirectory) {
        this.catalogDirectory = catologDirectory;
    }

    public String getPackageDirectory() {
        return this.packageDirectory;
    }

    public void setPackageDirectory(String newDirectory) {
        if (this.packageDirectory == null || !this.packageDirectory.equals(newDirectory)) {
            this.packageDirectory = newDirectory;
            this.loaded = false;
        }
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String newHost) {
        if (this.host == null || !this.host.equals(newHost)) {
            this.host = newHost;
            this.loaded = false;
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String newProxyHost) {
        String pHost = null;
        if (newProxyHost != null && newProxyHost.length() > 0) {
            pHost = newProxyHost;
        }
        if (this.proxyHost == null || !this.proxyHost.equals(pHost)) {
            this.proxyHost = pHost;
            this.loaded = false;
        }
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer newProxyPort) {
        if (this.proxyPort == null || !this.proxyPort.equals(newProxyPort)) {
            this.proxyPort = newProxyPort;
            this.loaded = false;
        }
    }

    protected URI getCachedIndexFile() throws InstallException {
        try {
            URI scratchdir = CWProject.instance().getWriteableProjectSubdir(AbstractSwordInstaller.getTempFileExtension(this.host, this.catalogDirectory), true);
            return NetUtil.lengthenURI((URI)scratchdir, (String)FILE_LIST_GZ);
        }
        catch (IOException ex) {
            throw new InstallException((MsgBase)Msg.URL_FAILED, ex);
        }
    }

    private static String getTempFileExtension(String host, String catalogDir) {
        return DOWNLOAD_PREFIX + host + catalogDir.replace('/', '_');
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractSwordInstaller)) {
            return false;
        }
        AbstractSwordInstaller that = (AbstractSwordInstaller)object;
        if (!this.equals(this.host, that.host)) {
            return false;
        }
        return this.equals(this.packageDirectory, that.packageDirectory);
    }

    public int compareTo(Object arg0) {
        HttpSwordInstaller myClass = (HttpSwordInstaller)arg0;
        int ret = this.host.compareTo(myClass.host);
        if (ret != 0) {
            ret = this.packageDirectory.compareTo(myClass.packageDirectory);
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode() + this.packageDirectory.hashCode();
    }

    protected boolean equals(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }
}

