/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.util.Locale;
import java.util.regex.Pattern;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.book.CaseType;
import org.crosswire.jsword.versification.BibleInfo;

public final class BookName {
    private static Pattern normPattern = Pattern.compile("[. ]");
    private int bookNumber;
    private String longName;
    private String normalizedLongName;
    private String shortName;
    private String normalizedShortName;
    private String[] alternateNames;
    private Locale locale;

    public BookName(Locale locale, int bookNumber, String longName, String shortName, String alternateNames) {
        this.locale = locale;
        this.bookNumber = bookNumber;
        this.longName = longName;
        this.normalizedLongName = BookName.normalize(longName, locale);
        this.shortName = shortName;
        this.normalizedShortName = BookName.normalize(shortName, locale);
        if (alternateNames != null) {
            this.alternateNames = StringUtil.split((String)BookName.normalize(alternateNames, locale), (char)',');
        }
    }

    public int getNumber() {
        return this.bookNumber;
    }

    public String getPreferredName() {
        if (BibleInfo.isFullBookName()) {
            return this.getLongName();
        }
        return this.getShortName();
    }

    public String getLongName() {
        CaseType bookCase = BibleInfo.getDefaultCase();
        if (bookCase == CaseType.LOWER) {
            return this.longName.toLowerCase(this.locale);
        }
        if (bookCase == CaseType.UPPER) {
            return this.longName.toUpperCase(this.locale);
        }
        return this.longName;
    }

    public String getShortName() {
        CaseType bookCase = BibleInfo.getDefaultCase();
        if (bookCase == CaseType.LOWER) {
            return this.shortName.toLowerCase(this.locale);
        }
        if (bookCase == CaseType.UPPER) {
            return this.shortName.toUpperCase(this.locale);
        }
        return this.shortName;
    }

    public String getNormalizedLongName() {
        return this.normalizedLongName;
    }

    public String getNormalizedShortName() {
        return this.normalizedShortName;
    }

    public boolean match(String normalizedName) {
        for (int j = 0; j < this.alternateNames.length; ++j) {
            String targetBookName = this.alternateNames[j];
            if (!targetBookName.startsWith(normalizedName) && !normalizedName.startsWith(targetBookName)) continue;
            return true;
        }
        if (this.normalizedLongName.startsWith(normalizedName)) {
            return true;
        }
        return this.normalizedShortName.startsWith(normalizedName) || normalizedName.startsWith(this.normalizedShortName);
    }

    public int hashCode() {
        return this.bookNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BookName other = (BookName)obj;
        return this.bookNumber == other.bookNumber;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public static String normalize(String str, Locale locale) {
        return normPattern.matcher(str).replaceAll("").toLowerCase(locale);
    }
}

