/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.index.AbstractIndex;
import org.crosswire.jsword.index.IndexStatus;
import org.crosswire.jsword.index.lucene.LuceneAnalyzer;
import org.crosswire.jsword.index.lucene.UserMsg;
import org.crosswire.jsword.index.search.SearchModifier;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;
import org.jdom.Element;

public class LuceneIndex
extends AbstractIndex
implements Activatable {
    private static final Object CREATING;
    private boolean active;
    private static final Logger log;
    protected static final String FIELD_KEY = "key";
    protected static final String FIELD_BODY = "content";
    protected static final String FIELD_STRONG = "strong";
    protected static final String FIELD_HEADING = "heading";
    protected static final String FIELD_XREF = "xref";
    protected static final String FIELD_NOTE = "note";
    protected Book book;
    private String path;
    protected Searcher searcher;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LuceneIndex(Book book, URI storage) throws BookException {
        this.book = book;
        try {
            this.path = NetUtil.getAsFile((URI)storage).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)UserMsg.LUCENE_INIT, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneIndex(Book book, URI storage, boolean create) throws BookException {
        if (!$assertionsDisabled && !create) {
            throw new AssertionError();
        }
        this.book = book;
        File finalPath = null;
        try {
            finalPath = NetUtil.getAsFile((URI)storage);
            this.path = finalPath.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BookException((MsgBase)UserMsg.LUCENE_INIT, ex);
        }
        DataPolice.setBook(book.getBookMetaData());
        Progress job = JobManager.createJob((String)UserMsg.INDEX_START.toString(book.getInitials()), (Thread)Thread.currentThread(), (boolean)false);
        IndexStatus finalStatus = IndexStatus.UNDONE;
        String bookLang = book.getLanguage().getName();
        LuceneAnalyzer analyzer = new LuceneAnalyzer(bookLang);
        ArrayList errors = new ArrayList();
        File tempPath = new File(this.path + '.' + IndexStatus.CREATING.toString());
        try {
            Object object = CREATING;
            synchronized (object) {
                book.setIndexStatus(IndexStatus.CREATING);
                RAMDirectory ramDir = new RAMDirectory();
                IndexWriter writer = new IndexWriter((Directory)ramDir, (Analyzer)analyzer, true);
                this.generateSearchIndexImpl(job, errors, writer, book.getGlobalKeyList(), 0);
                job.setSectionName(UserMsg.OPTIMIZING.toString());
                job.setWork(95);
                writer.close();
                IndexWriter fsWriter = new IndexWriter(tempPath.getCanonicalPath(), (Analyzer)analyzer, true);
                fsWriter.addIndexes(new Directory[]{ramDir});
                fsWriter.close();
                ramDir.close();
                job.setCancelable(false);
                if (!job.isFinished()) {
                    tempPath.renameTo(finalPath);
                }
                if (finalPath.exists()) {
                    finalStatus = IndexStatus.DONE;
                }
                if (errors.size() > 0) {
                    StringBuffer buf = new StringBuffer();
                    Iterator iter = errors.iterator();
                    while (iter.hasNext()) {
                        buf.append(iter.next());
                        buf.append('\n');
                    }
                    Reporter.informUser((Object)this, (MsgBase)UserMsg.BAD_VERSE, (Object)buf);
                }
            }
        }
        catch (IOException ex) {
            job.cancel();
            throw new BookException((MsgBase)UserMsg.LUCENE_INIT, ex);
        }
        finally {
            book.setIndexStatus(finalStatus);
            job.done();
        }
    }

    public Key find(String search) throws BookException {
        this.checkActive();
        SearchModifier modifier = this.getSearchModifier();
        Key results = null;
        if (search != null) {
            try {
                String bookLang = this.book.getLanguage().getName();
                LuceneAnalyzer analyzer = new LuceneAnalyzer(bookLang);
                QueryParser parser = new QueryParser(FIELD_BODY, (Analyzer)analyzer);
                parser.setAllowLeadingWildcard(true);
                Query query = parser.parse(search);
                log.info("ParsedQuery-" + query.toString());
                Hits hits = this.searcher.search(query);
                if (modifier != null && modifier.isRanked()) {
                    PassageTally tally = new PassageTally();
                    tally.raiseEventSuppresion();
                    tally.raiseNormalizeProtection();
                    results = tally;
                    for (int i = 0; i < hits.length(); ++i) {
                        Verse key = VerseFactory.fromString(hits.doc(i).get(FIELD_KEY));
                        int score = (int)(hits.score(i) * 100.0f + 1.0f);
                        tally.add(key, score);
                    }
                    tally.lowerNormalizeProtection();
                    tally.lowerEventSuppresionAndTest();
                } else {
                    results = this.book.createEmptyKeyList();
                    AbstractPassage passage = null;
                    if (results instanceof AbstractPassage) {
                        passage = (AbstractPassage)results;
                        passage.raiseEventSuppresion();
                        passage.raiseNormalizeProtection();
                    }
                    for (int i = 0; i < hits.length(); ++i) {
                        Verse key = VerseFactory.fromString(hits.doc(i).get(FIELD_KEY));
                        results.addAll(key);
                    }
                    if (passage != null) {
                        passage.lowerNormalizeProtection();
                        passage.lowerEventSuppresionAndTest();
                    }
                }
            }
            catch (IOException e) {
                throw new BookException((MsgBase)UserMsg.SEARCH_FAILED, e);
            }
            catch (NoSuchVerseException e) {
                throw new BookException((MsgBase)UserMsg.SEARCH_FAILED, (Throwable)((Object)e));
            }
            catch (ParseException e) {
                throw new BookException((MsgBase)UserMsg.SEARCH_FAILED, e);
            }
            finally {
                Activator.deactivate((Activatable)this);
            }
        }
        if (results == null) {
            results = modifier != null && modifier.isRanked() ? new PassageTally() : this.book.createEmptyKeyList();
        }
        return results;
    }

    public Key getKey(String name) throws NoSuchKeyException {
        return this.book.getKey(name);
    }

    public final void activate(Lock lock) {
        try {
            this.searcher = new IndexSearcher(this.path);
        }
        catch (IOException ex) {
            log.warn("second load failure", (Throwable)ex);
        }
        this.active = true;
    }

    public final void deactivate(Lock lock) {
        try {
            this.searcher.close();
            this.searcher = null;
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
        this.active = false;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    private void generateSearchIndexImpl(Progress job, List errors, IndexWriter writer, Key key, int count) throws BookException, IOException {
        boolean hasStrongs = this.book.getBookMetaData().hasFeature(FeatureType.STRONGS_NUMBERS);
        boolean hasXRefs = this.book.getBookMetaData().hasFeature(FeatureType.SCRIPTURE_REFERENCES);
        boolean hasNotes = this.book.getBookMetaData().hasFeature(FeatureType.FOOTNOTES);
        boolean hasHeadings = this.book.getBookMetaData().hasFeature(FeatureType.HEADINGS);
        String oldRootName = "";
        int percent = 0;
        String rootName = "";
        BookData data = null;
        Key subkey = null;
        Element osis = null;
        Document doc = new Document();
        Field keyField = new Field(FIELD_KEY, "", Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO);
        Field bodyField = new Field(FIELD_BODY, "", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
        Field strongField = new Field(FIELD_STRONG, "", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
        Field xrefField = new Field(FIELD_XREF, "", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
        Field noteField = new Field(FIELD_NOTE, "", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
        Field headingField = new Field(FIELD_HEADING, "", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
        int size = key.getCardinality();
        int subCount = count;
        Iterator it = key.iterator();
        while (it.hasNext()) {
            subkey = (Key)it.next();
            if (subkey.canHaveChildren()) {
                this.generateSearchIndexImpl(job, errors, writer, subkey, subCount);
                continue;
            }
            DataPolice.setKey(subkey);
            data = new BookData(this.book, subkey);
            osis = null;
            try {
                osis = data.getOsisFragment();
            }
            catch (BookException e) {
                errors.add(subkey);
                continue;
            }
            doc.getFields().clear();
            keyField.setValue(subkey.getOsisRef());
            doc.add((Fieldable)keyField);
            this.addField(doc, bodyField, OSISUtil.getCanonicalText(osis));
            if (hasStrongs) {
                this.addField(doc, strongField, OSISUtil.getStrongsNumbers(osis));
            }
            if (hasXRefs) {
                this.addField(doc, xrefField, OSISUtil.getReferences(osis));
            }
            if (hasNotes) {
                this.addField(doc, noteField, OSISUtil.getNotes(osis));
            }
            if (hasHeadings) {
                this.addField(doc, headingField, OSISUtil.getHeadings(osis));
            }
            if (doc.getFields().size() > 1) {
                writer.addDocument(doc);
            }
            if (!(rootName = subkey.getRootName()).equals(oldRootName)) {
                oldRootName = rootName;
                job.setSectionName(rootName);
            }
            percent = 95 * ++subCount / size;
            job.setWork(percent);
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
    }

    private void addField(Document doc, Field field, String text) {
        if (text != null && text.length() > 0) {
            field.setValue(text);
            doc.add((Fieldable)field);
        }
    }

    static {
        $assertionsDisabled = !LuceneIndex.class.desiredAssertionStatus();
        CREATING = new Object();
        log = Logger.getLogger((Class)LuceneIndex.class);
    }
}

