/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.TreeKeyIndex;
import org.crosswire.jsword.book.sword.TreeNode;
import org.crosswire.jsword.book.sword.UserMsg;
import org.crosswire.jsword.passage.AbstractKeyList;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.TreeKey;

public class GenBookBackend
extends AbstractBackend {
    private static final String EXTENSION_BDT = ".bdt";
    private File bdtFile;
    private RandomAccessFile bdtRaf;
    private TreeKeyIndex index;
    private boolean active;
    private static final Logger log = Logger.getLogger((Class)GenBookBackend.class);

    public GenBookBackend(SwordBookMetaData sbmd) {
        super(sbmd);
        this.index = new TreeKeyIndex(sbmd);
    }

    public final void activate(Lock lock) {
        Activator.activate((Activatable)this.index);
        URI path = null;
        try {
            path = this.getExpandedDataPath();
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
            return;
        }
        this.bdtFile = new File(path.getPath() + EXTENSION_BDT);
        if (!this.bdtFile.canRead()) {
            Reporter.informUser((Object)this, (LucidException)new BookException((MsgBase)UserMsg.READ_FAIL, new Object[]{this.bdtFile.getAbsolutePath()}));
            return;
        }
        try {
            this.bdtRaf = new RandomAccessFile(this.bdtFile, "r");
        }
        catch (IOException ex) {
            log.error("failed to open files", (Throwable)ex);
            this.bdtRaf = null;
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Lock lock) {
        try {
            if (this.bdtRaf != null) {
                this.bdtRaf.close();
            }
        }
        catch (IOException ex) {
            log.error("failed to close gen book files", (Throwable)ex);
        }
        finally {
            this.bdtRaf = null;
        }
        this.active = false;
        Activator.deactivate((Activatable)this.index);
    }

    public boolean contains(Key key) {
        this.checkActive();
        try {
            TreeNode node = this.find(key);
            byte[] userData = node.getUserData();
            return userData.length == 8;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        try {
            TreeNode node = this.find(key);
            byte[] userData = node.getUserData();
            if (userData.length == 8) {
                int start = SwordUtil.decodeLittleEndian32(userData, 0);
                int size = SwordUtil.decodeLittleEndian32(userData, 4);
                byte[] data = SwordUtil.readRAF(this.bdtRaf, start, size);
                this.decipher(data);
                return SwordUtil.decode(key.getName(), data, this.getBookMetaData().getBookCharset());
            }
            return "";
        }
        catch (IOException e) {
            throw new BookException(UserMsg.READ_FAIL, e, new Object[]{key.getName()});
        }
    }

    private TreeNode find(Key key) throws IOException {
        ArrayList<String> path = new ArrayList<String>();
        for (Key parentKey = key; parentKey != null && parentKey.getName().length() > 0; parentKey = parentKey.getParent()) {
            path.add(parentKey.getName());
        }
        TreeNode node = this.index.getRoot();
        node = this.index.getFirstChild(node);
        for (int i = path.size() - 1; i >= 0; --i) {
            String name = (String)path.get(i);
            while (node != null && !name.equals(node.getName())) {
                if (node.hasNextSibling()) {
                    node = this.index.getNextSibling(node);
                    continue;
                }
                log.error("Could not find " + name);
                node = null;
            }
            if (node == null || !name.equals(node.getName()) || i <= 0) continue;
            node = this.index.getFirstChild(node);
        }
        if (node != null && node.getName().equals(key.getName())) {
            return node;
        }
        return null;
    }

    public Key readIndex() {
        SwordBookMetaData bmd = this.getBookMetaData();
        AbstractKeyList reply = new DefaultKeyList(null, bmd.getName());
        try {
            TreeNode node = this.index.getRoot();
            reply = new TreeKey(node.getName(), null);
            this.doReadIndex(node, reply);
        }
        catch (IOException e) {
            log.error("Could not get read GenBook index", (Throwable)e);
        }
        return reply;
    }

    private void doReadIndex(TreeNode parentNode, Key parentKey) throws IOException {
        TreeNode currentNode = parentNode;
        if (currentNode.hasChildren()) {
            TreeNode childNode = this.index.getFirstChild(currentNode);
            while (true) {
                TreeKey childKey = new TreeKey(childNode.getName(), parentKey);
                parentKey.addAll(childKey);
                this.doReadIndex(childNode, childKey);
                if (!childNode.hasNextSibling()) break;
                childNode = this.index.getNextSibling(childNode);
            }
        }
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }
}

