/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.net.URI;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.crypt.Sapphire;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.passage.Key;

public abstract class AbstractBackend
implements Activatable {
    private SwordBookMetaData bmd;

    public AbstractBackend(SwordBookMetaData sbmd) {
        this.bmd = sbmd;
    }

    public SwordBookMetaData getBookMetaData() {
        return this.bmd;
    }

    public void decipher(byte[] data) {
        String cipherKeyString = (String)this.getBookMetaData().getProperty(ConfigEntryType.CIPHER_KEY);
        if (cipherKeyString != null) {
            Sapphire cipherEngine = new Sapphire(cipherKeyString.getBytes());
            for (int i = 0; i < data.length; ++i) {
                data[i] = cipherEngine.cipher(data[i]);
            }
            cipherEngine.burn();
        }
        cipherKeyString = null;
    }

    public void encipher(byte[] data) {
        this.decipher(data);
    }

    public URI getExpandedDataPath() throws BookException {
        URI loc = NetUtil.lengthenURI((URI)this.bmd.getLibrary(), (String)((String)this.bmd.getProperty(ConfigEntryType.DATA_PATH)));
        if (loc == null) {
            throw new BookException(Msg.MISSING_FILE);
        }
        return loc;
    }

    public Key readIndex() {
        return null;
    }

    public abstract boolean contains(Key var1);

    public abstract String getRawText(Key var1) throws BookException;

    public void setRawText(Key key, String text) {
        throw new UnsupportedOperationException("Could not set text (" + text + ") for " + key);
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }
}

