/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.readings;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBook;
import org.crosswire.jsword.book.basic.DefaultBookMetaData;
import org.crosswire.jsword.book.readings.Msg;
import org.crosswire.jsword.book.readings.ReadingsBookDriver;
import org.crosswire.jsword.book.readings.ReadingsKey;
import org.crosswire.jsword.book.readings.UserMsg;
import org.crosswire.jsword.passage.DefaultKeyList;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.PreferredKey;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.SetKeyList;
import org.crosswire.jsword.passage.VerseRange;
import org.jdom.Content;
import org.jdom.Element;

public class ReadingsBook
extends AbstractBook
implements PreferredKey {
    private Key global;
    private Map hash = new TreeMap();
    private static final Logger log = Logger.getLogger((Class)ReadingsBook.class);

    public ReadingsBook(ReadingsBookDriver driver, String setname, BookCategory type) {
        super(null);
        Locale defaultLocale = Locale.getDefault();
        ResourceBundle prop = ResourceBundle.getBundle(setname, defaultLocale, (ClassLoader)CWClassLoader.instance((Class)ReadingsBookDriver.class));
        String name = UserMsg.TITLE.toString();
        try {
            name = prop.getString("title");
        }
        catch (MissingResourceException e) {
            log.warn("Missing resource: 'title' while parsing: " + setname);
        }
        DefaultBookMetaData bmd = new DefaultBookMetaData((BookDriver)driver, name, type);
        bmd.setInitials(setname);
        bmd.setLanguage(new Language(Locale.getDefault().getLanguage()));
        this.setBookMetaData(bmd);
        GregorianCalendar greg = new GregorianCalendar();
        greg.set(5, 1);
        greg.set(2, 0);
        int currentYear = greg.get(1);
        while (greg.get(1) == currentYear) {
            String internalKey = ReadingsKey.external2internal(greg);
            String readings = "";
            try {
                readings = prop.getString(internalKey);
                this.hash.put(new ReadingsKey(greg.getTime()), readings);
            }
            catch (MissingResourceException e) {
                log.warn("Missing resource: " + internalKey + " while parsing: " + setname);
            }
            ((Calendar)greg).add(5, 1);
        }
        this.global = new SetKeyList(this.hash.keySet(), this.getName());
    }

    public Key getPreferred() {
        return new ReadingsKey(new Date());
    }

    public Iterator getOsisIterator(Key key, boolean allowEmpty) throws BookException {
        if (!(key instanceof ReadingsKey)) {
            throw new BookException((MsgBase)UserMsg.NOT_FOUND, new Object[]{key.getName()});
        }
        ArrayList<Object> content = new ArrayList<Object>();
        Element title = OSISUtil.factory().createTitle();
        title.addContent(key.getName());
        content.add(title);
        String readings = (String)this.hash.get(key);
        if (readings == null) {
            throw new BookException((MsgBase)UserMsg.NOT_FOUND, new Object[]{key.getName()});
        }
        try {
            KeyFactory keyf = PassageKeyFactory.instance();
            Passage ref = (Passage)keyf.getKey(readings);
            Element list = OSISUtil.factory().createList();
            content.add(list);
            Iterator it = ref.rangeIterator(RestrictionType.NONE);
            while (it.hasNext()) {
                VerseRange range = (VerseRange)it.next();
                Element reading = OSISUtil.factory().createReference();
                reading.setAttribute("osisRef", range.getOsisRef());
                reading.addContent(range.getName());
                Element item = OSISUtil.factory().createItem();
                item.addContent((Content)reading);
                list.addContent((Content)item);
            }
        }
        catch (NoSuchKeyException ex) {
            content.add(OSISUtil.factory().createText(Msg.PARSE_FAIL.toString(readings)));
        }
        return content.iterator();
    }

    public boolean contains(Key key) {
        return false;
    }

    public String getRawText(Key key) throws BookException {
        return "";
    }

    public boolean isWritable() {
        return false;
    }

    public void setRawText(Key key, String rawData) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    public void setAliasKey(Key alias, Key source) throws BookException {
        throw new BookException(Msg.DRIVER_READONLY);
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String name) throws NoSuchKeyException {
        DefaultKeyList reply = new DefaultKeyList();
        reply.addAll(new ReadingsKey(name, name, this.global));
        return reply;
    }

    public Key getGlobalKeyList() {
        return this.global;
    }

    public Key createEmptyKeyList() {
        return new DefaultKeyList();
    }

    public boolean hasFeature(FeatureType feature) {
        return feature == FeatureType.DAILY_DEVOTIONS;
    }
}

