/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install.sword;

import java.net.URI;
import java.net.URISyntaxException;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.WebResource;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.sword.AbstractSwordInstaller;
import org.crosswire.jsword.book.install.sword.UserMsg;

public class HttpSwordInstaller
extends AbstractSwordInstaller {
    public String getType() {
        return "sword-http";
    }

    public int getSize(Book book) {
        return NetUtil.getSize((URI)this.toRemoteURI(book), (String)this.proxyHost, (Integer)this.proxyPort);
    }

    public URI toRemoteURI(Book book) {
        try {
            return new URI("http", this.host, this.packageDirectory + '/' + book.getInitials() + ".zip", null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected void download(Progress job, String dir, String file, URI dest) throws InstallException {
        URI uri;
        try {
            uri = new URI("http", this.host, dir + '/' + file, null);
        }
        catch (URISyntaxException e1) {
            throw new InstallException(UserMsg.MISSING_FILE, e1, new Object[]{dir + '/' + file});
        }
        try {
            this.copy(job, uri, dest);
        }
        catch (LucidException ex) {
            throw new InstallException(UserMsg.MISSING_FILE, ex, new Object[]{uri.toString()});
        }
    }

    private void copy(Progress job, URI uri, URI dest) throws LucidException {
        if (job != null) {
            job.setSectionName(UserMsg.JOB_DOWNLOADING.toString());
        }
        WebResource wr = new WebResource(uri, this.proxyHost, this.proxyPort);
        wr.copy(dest);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpSwordInstaller)) {
            return false;
        }
        HttpSwordInstaller that = (HttpSwordInstaller)object;
        return super.equals(that);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

