/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import org.crosswire.common.util.DefaultURIFilter;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.util.URIFilter;
import org.crosswire.common.util.UserMsg;
import org.crosswire.common.util.WebResource;

public final class NetUtil {
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_FTP = "ftp";
    public static final String PROTOCOL_JAR = "jar";
    public static final String INDEX_FILE = "index.txt";
    public static final String SEPARATOR = "/";
    public static final String AUTH_SEPERATOR_USERNAME = "@";
    public static final String AUTH_SEPERATOR_PASSWORD = ":";
    private static final String TEMP_SUFFIX = "tmp";
    private static File cachedir;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NetUtil() {
    }

    public static URI copy(URI uri) {
        try {
            return new URI(uri.toString());
        }
        catch (URISyntaxException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)e);
            }
            return null;
        }
    }

    public static void makeDirectory(URI orig) throws MalformedURLException {
        NetUtil.checkFileURI(orig);
        File file = new File(orig.getPath());
        if (file.isFile()) {
            throw new MalformedURLException(UserMsg.IS_FILE.toString(orig));
        }
        if (!file.isDirectory()) {
            file.mkdirs();
            if (!file.isDirectory()) {
                throw new MalformedURLException(UserMsg.CREATE_DIR_FAIL.toString(orig));
            }
        }
    }

    public static void makeFile(URI orig) throws MalformedURLException, IOException {
        NetUtil.checkFileURI(orig);
        File file = new File(orig.getPath());
        if (file.isDirectory()) {
            throw new MalformedURLException(UserMsg.IS_DIR.toString(orig));
        }
        if (!file.isFile()) {
            FileOutputStream fout = new FileOutputStream(file);
            fout.close();
            if (!file.isFile()) {
                throw new MalformedURLException(UserMsg.CREATE_FILE_FAIL.toString(orig));
            }
        }
    }

    public static boolean isFile(URI uri) {
        if (uri.getScheme().equals(PROTOCOL_FILE)) {
            return new File(uri.getPath()).isFile();
        }
        try {
            uri.toURL().openStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isDirectory(URI orig) {
        if (!orig.getScheme().equals(PROTOCOL_FILE)) {
            return false;
        }
        return new File(orig.getPath()).isDirectory();
    }

    public static boolean canWrite(URI orig) {
        if (!orig.getScheme().equals(PROTOCOL_FILE)) {
            return false;
        }
        return new File(orig.getPath()).canWrite();
    }

    public static boolean canRead(URI orig) {
        if (!orig.getScheme().equals(PROTOCOL_FILE)) {
            return false;
        }
        return new File(orig.getPath()).canRead();
    }

    public static boolean move(URI oldUri, URI newUri) throws IOException {
        NetUtil.checkFileURI(oldUri);
        NetUtil.checkFileURI(newUri);
        File oldFile = new File(oldUri.getPath());
        File newFile = new File(newUri.getPath());
        return oldFile.renameTo(newFile);
    }

    public static boolean delete(URI orig) throws IOException {
        NetUtil.checkFileURI(orig);
        return new File(orig.getPath()).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getAsFile(URI uri) throws IOException {
        if (uri.getScheme().equals(PROTOCOL_FILE)) {
            return new File(uri.getPath());
        }
        String hashString = (uri.toString().hashCode() + "").replace('-', 'm');
        File workingDir = NetUtil.getURICacheDir();
        File workingFile = null;
        workingFile = workingDir != null && workingDir.isDirectory() ? new File(workingDir, hashString) : File.createTempFile(hashString, TEMP_SUFFIX);
        workingFile.deleteOnExit();
        FileOutputStream output = null;
        InputStream input = null;
        try {
            output = new FileOutputStream(workingFile);
            input = uri.toURL().openStream();
            byte[] data = new byte[512];
            int read = 0;
            while (read != -1) {
                ((OutputStream)output).write(data, 0, read);
                read = input.read(data);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            finally {
                if (output != null) {
                    ((OutputStream)output).close();
                }
            }
        }
        return workingFile;
    }

    public static URI shortenURI(URI orig, String strip) throws MalformedURLException {
        String test;
        String file = orig.getPath();
        char lastChar = file.charAt(file.length() - 1);
        if (NetUtil.isSeparator(lastChar)) {
            file = file.substring(0, file.length() - 1);
        }
        if (!(test = file.substring(file.length() - strip.length())).equals(strip)) {
            throw new MalformedURLException(Msg.CANT_STRIP.toString(new Object[]{orig, strip}));
        }
        String newFile = file.substring(0, file.length() - strip.length());
        try {
            return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), newFile, "", "");
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(Msg.CANT_STRIP.toString(new Object[]{orig, strip}));
        }
    }

    public static URI lengthenURI(URI orig, String anExtra) {
        String extra = anExtra;
        try {
            char firstChar = extra.charAt(0);
            if (NetUtil.isSeparator(firstChar)) {
                extra = extra.substring(1);
            }
            if (orig.getScheme().equals(PROTOCOL_FILE)) {
                String file = orig.toString();
                char lastChar = file.charAt(file.length() - 1);
                if (NetUtil.isSeparator(lastChar)) {
                    return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), orig.getPath() + extra, orig.getQuery(), orig.getFragment());
                }
                return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), orig.getPath() + File.separator + extra, orig.getQuery(), orig.getFragment());
            }
            return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), orig.getPath() + SEPARATOR + extra, orig.getQuery(), orig.getFragment());
        }
        catch (URISyntaxException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    private static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    public static InputStream getInputStream(URI uri) throws IOException {
        if (uri.getScheme().equals(PROTOCOL_FILE)) {
            return new FileInputStream(uri.getPath());
        }
        return uri.toURL().openStream();
    }

    public static OutputStream getOutputStream(URI uri) throws IOException {
        return NetUtil.getOutputStream(uri, false);
    }

    public static OutputStream getOutputStream(URI uri, boolean append) throws IOException {
        if (uri.getScheme().equals(PROTOCOL_FILE)) {
            return new FileOutputStream(uri.getPath(), append);
        }
        URLConnection cnx = uri.toURL().openConnection();
        cnx.setDoOutput(true);
        return cnx.getOutputStream();
    }

    public static String[] list(URI uri, URIFilter filter) throws MalformedURLException, IOException {
        String[] reply;
        block6: {
            reply = new String[]{};
            try {
                URI search = NetUtil.lengthenURI(uri, INDEX_FILE);
                reply = NetUtil.listByIndexFile(search, filter);
            }
            catch (FileNotFoundException ex) {
                log.warn("index file for " + uri.toString() + " was not found.");
                if (!uri.getScheme().equals(PROTOCOL_FILE)) break block6;
                return NetUtil.listByFile(uri, filter);
            }
        }
        if (uri.getScheme().equals(PROTOCOL_FILE)) {
            String[] files = NetUtil.listByFile(uri, filter);
            if (files.length != reply.length) {
                log.warn("index file for " + uri.toString() + " has incorrect number of entries.");
            } else {
                List<String> list = Arrays.asList(files);
                for (int i = 0; i < files.length; ++i) {
                    if (list.contains(files[i])) continue;
                    log.warn("file: based index found " + files[i] + " but this was not found using index file.");
                }
            }
        }
        return reply;
    }

    public static String[] listByFile(URI uri, URIFilter filter) throws MalformedURLException {
        File fdir = new File(uri.getPath());
        if (!fdir.isDirectory()) {
            throw new MalformedURLException(UserMsg.NOT_DIR.toString(uri.toString()));
        }
        return fdir.list(new URIFilterFilenameFilter(filter));
    }

    public static String[] listByIndexFile(URI index) throws IOException {
        return NetUtil.listByIndexFile(index, new DefaultURIFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listByIndexFile(URI index, URIFilter filter) throws IOException {
        InputStream in = null;
        try {
            in = NetUtil.getInputStream(index);
            String contents = StringUtil.read(new InputStreamReader(in));
            ArrayList<String> list = new ArrayList<String>();
            String[] names = StringUtil.split(contents, "\n");
            for (int i = 0; i < names.length; ++i) {
                String name = names[i].trim();
                if (name.length() <= 0 || name.charAt(0) == '#' || name.equals(INDEX_FILE) || !filter.accept(name)) continue;
                list.add(name);
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        finally {
            IOUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(URI uri) throws IOException {
        InputStream is = null;
        try {
            is = NetUtil.getInputStream(uri);
            Properties prop = new Properties();
            prop.load(is);
            is.close();
            Properties properties = prop;
            return properties;
        }
        finally {
            IOUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(Properties properties, URI uri, String title) throws IOException {
        OutputStream out = null;
        try {
            out = NetUtil.getOutputStream(uri);
            properties.store(out, title);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static int getSize(URI uri) {
        return NetUtil.getSize(uri, null, null);
    }

    public static int getSize(URI uri, String proxyHost) {
        return NetUtil.getSize(uri, proxyHost, null);
    }

    public static int getSize(URI uri, String proxyHost, Integer proxyPort) {
        try {
            if (uri.getScheme().equals(PROTOCOL_HTTP)) {
                return new WebResource(uri, proxyHost, proxyPort).getSize();
            }
            return uri.toURL().openConnection().getContentLength();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static long getLastModified(URI uri) {
        return NetUtil.getLastModified(uri, null, null);
    }

    public static long getLastModified(URI uri, String proxyHost) {
        return NetUtil.getLastModified(uri, proxyHost, null);
    }

    public static long getLastModified(URI uri, String proxyHost, Integer proxyPort) {
        try {
            if (uri.getScheme().equals(PROTOCOL_HTTP)) {
                return new WebResource(uri, proxyHost, proxyPort).getLastModified();
            }
            URLConnection urlConnection = uri.toURL().openConnection();
            long time = urlConnection.getLastModified();
            if (urlConnection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)urlConnection;
                JarEntry jarEntry = jarConnection.getJarEntry();
                time = jarEntry.getTime();
            }
            return time;
        }
        catch (IOException ex) {
            log.warn("Failed to get modified time", ex);
            return new Date().getTime();
        }
    }

    public static boolean isNewer(URI left, URI right) {
        return NetUtil.isNewer(left, right, null, null);
    }

    public static boolean isNewer(URI left, URI right, String proxyHost) {
        return NetUtil.isNewer(left, right, proxyHost, null);
    }

    public static boolean isNewer(URI left, URI right, String proxyHost, Integer proxyPort) {
        return NetUtil.getLastModified(left, proxyHost, proxyPort) > NetUtil.getLastModified(right, proxyHost, proxyPort);
    }

    private static void checkFileURI(URI uri) throws MalformedURLException {
        if (!uri.getScheme().equals(PROTOCOL_FILE)) {
            throw new MalformedURLException(UserMsg.NOT_FILE_URI.toString(uri));
        }
    }

    public static File getURICacheDir() {
        return cachedir;
    }

    public static void setURICacheDir(File cachedir) {
        NetUtil.cachedir = cachedir;
    }

    public static URI getURI(File file) {
        return file.toURI();
    }

    public static URI getTemporaryURI(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        return NetUtil.getURI(tempFile);
    }

    public static URI toURI(URL url) {
        try {
            return new URI(url.toExternalForm());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static {
        $assertionsDisabled = !NetUtil.class.desiredAssertionStatus();
        log = Logger.getLogger(NetUtil.class);
    }

    public static class IsDirectoryURIFilter
    implements URIFilter {
        private URI parent;

        public IsDirectoryURIFilter(URI parent) {
            this.parent = parent;
        }

        public boolean accept(String name) {
            return NetUtil.isDirectory(NetUtil.lengthenURI(this.parent, name));
        }
    }

    public static class URIFilterFilenameFilter
    implements FilenameFilter {
        private URIFilter filter;

        public URIFilterFilenameFilter(URIFilter filter) {
            this.filter = filter;
        }

        public boolean accept(File arg0, String name) {
            return this.filter.accept(name);
        }
    }
}

