/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.basic;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.JTextPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.book.install.BookFont;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.URIEvent;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.display.basic.Msg;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.common.swing.AntiAliasedTextPane;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookData;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.util.ConverterFactory;
import org.xml.sax.SAXException;

public class TextPaneBookDataDisplay
implements BookDataDisplay,
HyperlinkListener,
PropertyChangeListener {
    private static final String HYPERLINK_STYLE = "Hyperlink";
    private static final String DOUBLE_SLASH = "//";
    private static final String SCROLL_TO_URI = "scrolling to: {0}";
    private static final String RELATIVE_URI_PROTOCOL = "";
    protected static final Logger log = Logger.getLogger((Class)TextPaneBookDataDisplay.class);
    private BookData bdata;
    private boolean compareBooks;
    private Converter converter;
    private JTextPane txtView;
    private Style style;
    private int lastStart;
    private int lastLength;
    private StyledDocument styledDoc;
    private EventListenerList listenerList = new EventListenerList();

    public TextPaneBookDataDisplay() {
        this.converter = ConverterFactory.getConverter();
        this.txtView = new AntiAliasedTextPane();
        this.txtView.setEditable(false);
        this.txtView.setEditorKit(new HTMLEditorKit());
        this.txtView.addHyperlinkListener(this);
        this.style = this.txtView.addStyle(HYPERLINK_STYLE, null);
        this.styledDoc = this.txtView.getStyledDocument();
        this.lastStart = -1;
        this.lastLength = -1;
    }

    public void clearBookData() {
        this.setBookData(null, null);
    }

    public void setBookData(Book[] books, Key key) {
        if (books == null || books.length == 0 || books[0] == null || key == null) {
            this.bdata = null;
        } else if (this.bdata == null || !Arrays.equals(books, this.bdata.getBooks()) || !key.equals(this.bdata.getKey())) {
            this.bdata = new BookData(books, key, this.compareBooks);
        }
        this.refresh();
    }

    public void setCompareBooks(boolean compare) {
        this.compareBooks = compare;
        if (this.bdata != null) {
            this.bdata = new BookData(this.bdata.getBooks(), this.bdata.getKey(), this.compareBooks);
            this.refresh();
        }
    }

    public void refresh() {
        if (this.bdata == null) {
            this.txtView.setText(RELATIVE_URI_PROTOCOL);
            return;
        }
        BookMetaData bmd = this.getFirstBook().getBookMetaData();
        if (bmd == null) {
            this.txtView.setText(RELATIVE_URI_PROTOCOL);
            return;
        }
        boolean direction = bmd.isLeftToRight();
        GuiUtil.applyOrientation((Component)this.txtView, (boolean)direction);
        String fontSpec = GuiConvert.font2String((Font)BookFont.instance().getFont(this.getFirstBook()));
        try {
            String javaVersion;
            SAXEventProvider osissep = this.bdata.getSAXEventProvider();
            TransformingSAXEventProvider htmlsep = (TransformingSAXEventProvider)this.converter.convert(osissep);
            XSLTProperty.DIRECTION.setState(direction ? "ltr" : "rtl");
            URI loc = bmd.getLocation();
            XSLTProperty.BASE_URL.setState(loc == null ? RELATIVE_URI_PROTOCOL : loc.getPath());
            if (bmd.getBookCategory() == BookCategory.BIBLE) {
                XSLTProperty.setProperties(htmlsep);
            } else {
                XSLTProperty.CSS.setProperty(htmlsep);
                XSLTProperty.BASE_URL.setProperty(htmlsep);
                XSLTProperty.DIRECTION.setProperty(htmlsep);
            }
            htmlsep.setParameter(XSLTProperty.FONT.getName(), (Object)fontSpec);
            String text = XMLUtil.writeToString((SAXEventProvider)htmlsep);
            if (text.length() > 32768 && BookCategory.GENERAL_BOOK.equals((Object)this.getFirstBook().getBookCategory()) && ((javaVersion = System.getProperty("java.specification.version")) == null || "1.5".compareTo(javaVersion) > 0)) {
                text = text.substring(0, 32760) + "...";
            }
            this.txtView.setText(text);
            this.txtView.select(0, 0);
        }
        catch (SAXException e) {
            Reporter.informUser((Object)this, (Throwable)e);
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
        catch (TransformerException e) {
            Reporter.informUser((Object)this, (Throwable)e);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent ev) {
        try {
            HyperlinkEvent.EventType type = ev.getEventType();
            JTextPane pane = (JTextPane)ev.getSource();
            String uri = ev.getDescription();
            String[] parts = this.getParts(uri);
            if (type == HyperlinkEvent.EventType.ACTIVATED) {
                if (parts[1].length() > 0) {
                    if (parts[1].charAt(0) == '#') {
                        log.debug(MessageFormat.format(SCROLL_TO_URI, uri));
                        uri = uri.substring(1);
                        pane.scrollToReference(uri);
                    } else {
                        this.fireActivateURI(new URIEvent(this, parts[0], parts[1]));
                    }
                }
            } else {
                boolean isEnter = type == HyperlinkEvent.EventType.ENTERED;
                int start = this.lastStart;
                int length = this.lastLength;
                if (isEnter) {
                    Element textElement = ev.getSourceElement();
                    start = textElement.getStartOffset();
                    length = textElement.getEndOffset() - start;
                    this.lastStart = start;
                    this.lastLength = length;
                }
                StyleConstants.setUnderline(this.style, isEnter);
                this.styledDoc.setCharacterAttributes(start, length, this.style, false);
                if (isEnter) {
                    this.fireEnterURI(new URIEvent(this, parts[0], parts[1]));
                } else {
                    this.fireLeaveURI(new URIEvent(this, parts[0], parts[1]));
                }
            }
        }
        catch (MalformedURLException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ComparingBooks")) {
            this.setCompareBooks(Boolean.valueOf(evt.getNewValue().toString()));
        }
    }

    private String[] getParts(String reference) throws MalformedURLException {
        String protocol = RELATIVE_URI_PROTOCOL;
        String data = reference;
        int match = data.indexOf(58);
        if (match == -1) {
            if (data.charAt(0) != '#') {
                throw new MalformedURLException(Msg.BAD_PROTOCOL_URL.toString(data));
            }
        } else {
            protocol = data.substring(0, match);
            data = data.substring(match + 1);
        }
        if (data.startsWith(DOUBLE_SLASH)) {
            data = data.substring(2);
        }
        return new String[]{protocol, data};
    }

    public Component getComponent() {
        return this.txtView;
    }

    public void copy() {
        this.txtView.copy();
    }

    public synchronized void addKeyChangeListener(KeyChangeListener listener) {
        this.listenerList.add(KeyChangeListener.class, listener);
    }

    public synchronized void removeKeyChangeListener(KeyChangeListener listener) {
        this.listenerList.remove(KeyChangeListener.class, listener);
    }

    public synchronized void addURIEventListener(URIEventListener listener) {
        this.listenerList.add(URIEventListener.class, listener);
    }

    public synchronized void removeURIEventListener(URIEventListener listener) {
        this.listenerList.remove(URIEventListener.class, listener);
    }

    public void fireActivateURI(URIEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$bibledesktop$display$URIEventListener == null ? TextPaneBookDataDisplay.class$("org.crosswire.bibledesktop.display.URIEventListener") : class$org$crosswire$bibledesktop$display$URIEventListener)) continue;
            ((URIEventListener)listeners[i + 1]).activateURI(e);
        }
    }

    public void fireEnterURI(URIEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$bibledesktop$display$URIEventListener == null ? TextPaneBookDataDisplay.class$("org.crosswire.bibledesktop.display.URIEventListener") : class$org$crosswire$bibledesktop$display$URIEventListener)) continue;
            ((URIEventListener)listeners[i + 1]).enterURI(e);
        }
    }

    public void fireLeaveURI(URIEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$bibledesktop$display$URIEventListener == null ? TextPaneBookDataDisplay.class$("org.crosswire.bibledesktop.display.URIEventListener") : class$org$crosswire$bibledesktop$display$URIEventListener)) continue;
            ((URIEventListener)listeners[i + 1]).leaveURI(e);
        }
    }

    public void removeMouseListener(MouseListener li) {
        this.txtView.removeMouseListener(li);
    }

    public void addMouseListener(MouseListener li) {
        this.txtView.addMouseListener(li);
    }

    public Key getKey() {
        return this.bdata == null ? null : this.bdata.getKey();
    }

    public Book[] getBooks() {
        return this.bdata.getBooks();
    }

    public Book getFirstBook() {
        return this.bdata.getFirstBook();
    }
}

