/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.Font;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.common.swing.FontStore;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.book.Book;

public class BookFont
extends FontStore {
    static BookFont fonts = new BookFont();

    private BookFont() {
        super("BookFonts", CWProject.instance().getWritableProjectDir());
    }

    public static BookFont instance() {
        return fonts;
    }

    public void setFont(Book book, Font font) {
        super.setFont(book.getInitials(), font);
    }

    public Font getFont(Book book) {
        Font bookFont;
        String fontName = (String)book.getBookMetaData().getProperty("Font");
        String fontSpec = XSLTProperty.FONT.getStringState();
        if (fontName != null && (bookFont = GuiConvert.deriveFont((String)fontSpec, (String)fontName)).getFamily().equalsIgnoreCase(fontName)) {
            fontSpec = GuiConvert.font2String((Font)bookFont);
        }
        return fonts.getFont(book.getInitials(), book.getLanguage(), fontSpec);
    }

    public Font getFont(Language language) {
        return fonts.getFont(null, language, null);
    }
}

