/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import org.crosswire.common.config.Config;
import org.crosswire.common.config.swing.ConfigEditor;
import org.crosswire.common.config.swing.UserMsg;
import org.crosswire.common.util.LucidRuntimeException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.common.util.Reporter;

public final class ConfigEditorFactory {
    private ConfigEditorFactory() {
    }

    public static void showDialog(Config config, Component parent, ActionListener al) {
        Exception ex = null;
        try {
            ConfigEditor base = (ConfigEditor)PluginUtil.getImplementation((Class)ConfigEditor.class);
            base.construct(config);
            base.showDialog(parent, al);
        }
        catch (ClassCastException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (ClassNotFoundException e) {
            ex = e;
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        if (ex != null) {
            Reporter.informUser((Object)parent, (Throwable)ex);
        }
    }

    public static void showDialog(Config config, Component parent, URI uri) {
        ConfigEditorFactory.showDialog(config, parent, new URIActionListener(config, uri));
    }

    static class URIActionListener
    implements ActionListener {
        private Config config;
        private URI uri;

        public URIActionListener(Config config, URI uri) {
            this.config = config;
            this.uri = uri;
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                this.config.localToApplication();
                this.config.localToPermanent(this.uri);
            }
            catch (IOException ex) {
                throw new LucidRuntimeException((MsgBase)UserMsg.CONFIG_SAVE_FAILED, (Throwable)ex, new Object[]{this.uri});
            }
        }
    }
}

