/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.Grego;
import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.OlsonTimeZone;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import java.lang.ref.SoftReference;
import java.text.ParsePosition;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;

public final class ZoneMeta {
    private static final boolean ASSERT = false;
    private static Map canonicalMap = null;
    private static Set multiZoneTerritories = null;
    public static final String HOUR = "hourFormat";
    public static final String GMT = "gmtFormat";
    public static final String REGION_FORMAT = "regionFormat";
    public static final String FALLBACK_FORMAT = "fallbackFormat";
    public static final String ZONE_STRINGS = "zoneStrings";
    public static final String FORWARD_SLASH = "/";
    private static final String[] EMPTY = new String[0];
    private static final String kREGIONS = "Regions";
    private static final String kZONES = "Zones";
    private static final String kNAMES = "Names";
    private static final String kGMT_ID = "GMT";
    private static final String kCUSTOM_TZ_PREFIX = "GMT";
    private static ICUCache zoneCache = new SimpleCache();
    static int OLSON_ZONE_START = -1;
    static int OLSON_ZONE_COUNT = 0;
    private static final int kMAX_CUSTOM_HOUR = 23;
    private static final int kMAX_CUSTOM_MIN = 59;
    private static final int kMAX_CUSTOM_SEC = 59;
    private static SoftReference OLSON_TO_META_REF;
    private static SoftReference META_TO_OLSON_REF;
    static /* synthetic */ Class class$com$ibm$icu$impl$ZoneMeta;

    public static synchronized String[] getAvailableIDs(String country) {
        if (!ZoneMeta.getOlsonMeta()) {
            return EMPTY;
        }
        try {
            ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle regions = top.get(kREGIONS);
            UResourceBundle names = top.get(kNAMES);
            UResourceBundle temp = regions.get(country);
            int[] vector = temp.getIntVector();
            String[] ret = new String[vector.length];
            for (int i = 0; i < vector.length; ++i) {
                ret[i] = names.getString(vector[i]);
            }
            return ret;
        }
        catch (MissingResourceException missingResourceException) {
            return EMPTY;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        if (!ZoneMeta.getOlsonMeta()) {
            return EMPTY;
        }
        try {
            ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle names = top.get(kNAMES);
            return names.getStringArray();
        }
        catch (MissingResourceException missingResourceException) {
            return EMPTY;
        }
    }

    public static synchronized String[] getAvailableIDs(int offset) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < OLSON_ZONE_COUNT; ++i) {
            TimeZone z;
            String unistr = ZoneMeta.getID(i);
            if (unistr == null || (z = TimeZone.getTimeZone(unistr)) == null || !z.getID().equals(unistr) || z.getRawOffset() != offset) continue;
            vector.add(unistr);
        }
        if (!vector.isEmpty()) {
            String[] strings = new String[vector.size()];
            return vector.toArray(strings);
        }
        return EMPTY;
    }

    private static String getID(int i) {
        try {
            ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle names = top.get(kNAMES);
            return names.getString(i);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static synchronized int countEquivalentIDs(String id) {
        UResourceBundle res = ZoneMeta.openOlsonResource(id);
        int size = res.getSize();
        if (size == 4 || size == 6) {
            UResourceBundle r = res.get(size - 1);
            int[] v = r.getIntVector();
            return v.length;
        }
        return 0;
    }

    public static synchronized String getEquivalentID(String id, int index) {
        String result = "";
        UResourceBundle res = ZoneMeta.openOlsonResource(id);
        int zone = -1;
        int size = res.getSize();
        if (size == 4 || size == 6) {
            UResourceBundle r = res.get(size - 1);
            int[] v = r.getIntVector();
            if (index >= 0 && index < v.length && ZoneMeta.getOlsonMeta()) {
                zone = v[index];
            }
        }
        if (zone >= 0) {
            UResourceBundle top = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle ares = top.get(kNAMES);
            result = ares.getString(zone);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCanonicalInfo(String id) {
        String olsonCanonicalID = ZoneMeta.getOlsonCanonicalID(id);
        if (olsonCanonicalID == null) {
            return null;
        }
        if (canonicalMap == null) {
            HashMap<String, String[]> m = new HashMap<String, String[]>();
            HashSet<String> s = new HashSet<String>();
            UResourceBundle supplementalDataBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle zoneFormatting = supplementalDataBundle.get("zoneFormatting");
            UResourceBundleIterator it = zoneFormatting.getIterator();
            block9: while (it.hasNext()) {
                UResourceBundle temp = it.next();
                int resourceType = temp.getType();
                switch (resourceType) {
                    case 2: {
                        String[] result = new String[]{"", ""};
                        UResourceBundle zoneInfo = temp;
                        String canonicalID = zoneInfo.getKey().replace(':', '/');
                        String territory = zoneInfo.get("territory").getString();
                        result[0] = canonicalID;
                        result[1] = territory.equals("001") ? null : territory;
                        m.put(canonicalID, result);
                        try {
                            UResourceBundle aliasBundle = zoneInfo.get("aliases");
                            String[] aliases = aliasBundle.getStringArray();
                            for (int i = 0; i < aliases.length; ++i) {
                                m.put(aliases[i], result);
                            }
                            continue block9;
                        }
                        catch (MissingResourceException ex) {
                            break;
                        }
                    }
                    case 8: {
                        String[] territoryList = temp.getStringArray();
                        for (int i = 0; i < territoryList.length; ++i) {
                            s.add(territoryList[i]);
                        }
                        break;
                    }
                }
            }
            Class clazz = class$com$ibm$icu$impl$ZoneMeta == null ? (class$com$ibm$icu$impl$ZoneMeta = ZoneMeta.class$("com.ibm.icu.impl.ZoneMeta")) : class$com$ibm$icu$impl$ZoneMeta;
            synchronized (clazz) {
                canonicalMap = m;
                multiZoneTerritories = s;
            }
        }
        return (String[])canonicalMap.get(olsonCanonicalID);
    }

    public static String getCanonicalID(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[0];
        }
        return tzid;
    }

    public static String getCanonicalCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[1];
        }
        return null;
    }

    public static String getSingleCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null && info[1] != null && !multiZoneTerritories.contains(info[1])) {
            return info[1];
        }
        return null;
    }

    public static String getLocationFormat(String tzid, String city, ULocale locale) {
        MessageFormat mf;
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info == null) {
            return null;
        }
        String country_code = info[1];
        if (country_code == null) {
            return null;
        }
        String country = null;
        if (country_code != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", locale);
            ULocale rbloc = rb.getULocale();
            if (!rbloc.equals(ULocale.ROOT) && rbloc.getLanguage().equals(locale.getLanguage())) {
                country = ULocale.getDisplayCountry("xx_" + country_code, locale);
            }
            if (country == null || country.length() == 0) {
                country = country_code;
            }
        }
        if (ZoneMeta.getSingleCountry(tzid) != null) {
            String regPat = ZoneMeta.getTZLocalizationInfo(locale, REGION_FORMAT);
            mf = new MessageFormat(regPat);
            return mf.format(new Object[]{country});
        }
        if (city == null) {
            city = tzid.substring(tzid.lastIndexOf(47) + 1).replace('_', ' ');
        }
        String flbPat = ZoneMeta.getTZLocalizationInfo(locale, FALLBACK_FORMAT);
        mf = new MessageFormat(flbPat);
        return mf.format(new Object[]{city, country});
    }

    public static String getTZLocalizationInfo(ULocale locale, String format) {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance(locale);
        return bundle.getStringWithFallback("zoneStrings/" + format);
    }

    public static UResourceBundle openOlsonResource(String id) {
        if (!ZoneMeta.getOlsonMeta()) {
            return null;
        }
        ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle res = ZoneMeta.getZoneByName(top, id);
        if (res.getSize() <= 1 && ZoneMeta.getOlsonMeta(top)) {
            int deref = res.getInt() + 0;
            UResourceBundle ares = top.get(kZONES);
            res = (ICUResourceBundle)ares.get(deref);
        }
        return res;
    }

    public static synchronized String getOlsonCanonicalID(String id) {
        if (!ZoneMeta.getOlsonMeta()) {
            return null;
        }
        String canonicalID = null;
        ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        try {
            UResourceBundle res = ZoneMeta.getZoneByName(top, id);
            if (res.getSize() == 1) {
                int deref = res.getInt();
                UResourceBundle names = top.get(kNAMES);
                canonicalID = names.getString(deref);
            } else {
                canonicalID = id;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return canonicalID;
    }

    private static UResourceBundle getZoneByName(UResourceBundle top, String id) {
        UResourceBundle tmp = top.get(kNAMES);
        int idx = ZoneMeta.findInStringArray(tmp, id);
        if (idx == -1) {
            throw new MissingResourceException(kNAMES, ((ICUResourceBundle)tmp).getResPath(), id);
        }
        tmp = top.get(kZONES);
        tmp = tmp.get(idx);
        return tmp;
    }

    private static int findInStringArray(UResourceBundle array, String id) {
        int mid;
        int start = 0;
        int limit = array.getSize();
        String u = null;
        int lastMid = Integer.MAX_VALUE;
        if (limit < 1) {
            return -1;
        }
        while (lastMid != (mid = (start + limit) / 2)) {
            lastMid = mid;
            u = array.getString(mid);
            if (u == null) break;
            int r = id.compareTo(u);
            if (r == 0) {
                return mid;
            }
            if (r < 0) {
                limit = mid;
                continue;
            }
            start = mid;
        }
        return -1;
    }

    private static boolean getOlsonMeta(ICUResourceBundle top) {
        if (OLSON_ZONE_START < 0) {
            UResourceBundle res = top.get(kZONES);
            OLSON_ZONE_COUNT = res.getSize();
            OLSON_ZONE_START = 0;
        }
        return OLSON_ZONE_START >= 0;
    }

    private static boolean getOlsonMeta() {
        ICUResourceBundle top = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (OLSON_ZONE_START < 0) {
            ZoneMeta.getOlsonMeta(top);
        }
        return OLSON_ZONE_START >= 0;
    }

    public static TimeZone getSystemTimeZone(String id) {
        TimeZone z = (TimeZone)zoneCache.get(id);
        if (z == null) {
            try {
                UResourceBundle top = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "zoneinfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle res = ZoneMeta.openOlsonResource(id);
                z = new OlsonTimeZone(top, res);
                z.setID(id);
                zoneCache.put(id, z);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return (TimeZone)z.clone();
    }

    public static TimeZone getGMT() {
        SimpleTimeZone z = new SimpleTimeZone(0, "GMT");
        ((TimeZone)z).setID("GMT");
        return z;
    }

    public static TimeZone getCustomTimeZone(String id) {
        NumberFormat numberFormat = null;
        String idUppercase = id.toUpperCase();
        if (id.length() > "GMT".length() && idUppercase.startsWith("GMT")) {
            ParsePosition pos = new ParsePosition("GMT".length());
            boolean negative = false;
            int hour = 0;
            int min = 0;
            int sec = 0;
            if (id.charAt(pos.getIndex()) == '-') {
                negative = true;
            } else if (id.charAt(pos.getIndex()) != '+') {
                return null;
            }
            pos.setIndex(pos.getIndex() + 1);
            numberFormat = NumberFormat.getInstance();
            numberFormat.setParseIntegerOnly(true);
            int start = pos.getIndex();
            Number n = numberFormat.parse(id, pos);
            if (pos.getIndex() == start) {
                return null;
            }
            hour = n.intValue();
            if (pos.getIndex() < id.length()) {
                if (pos.getIndex() - start > 2 || id.charAt(pos.getIndex()) != ':') {
                    return null;
                }
                pos.setIndex(pos.getIndex() + 1);
                int oldPos = pos.getIndex();
                n = numberFormat.parse(id, pos);
                if (pos.getIndex() - oldPos != 2) {
                    return null;
                }
                min = n.intValue();
                if (pos.getIndex() < id.length()) {
                    if (id.charAt(pos.getIndex()) != ':') {
                        return null;
                    }
                    pos.setIndex(pos.getIndex() + 1);
                    oldPos = pos.getIndex();
                    n = numberFormat.parse(id, pos);
                    if (pos.getIndex() != id.length() || pos.getIndex() - oldPos != 2) {
                        return null;
                    }
                    sec = n.intValue();
                }
            } else {
                int length = pos.getIndex() - start;
                if (length <= 0 || 6 < length) {
                    return null;
                }
                switch (length) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        min = hour % 100;
                        hour /= 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        sec = hour % 100;
                        min = hour / 100 % 100;
                        hour /= 10000;
                    }
                }
            }
            if (hour > 23 || min > 59 || sec > 59) {
                return null;
            }
            String zid = ZoneMeta.getCustomID(hour, min, sec, negative);
            int offset = ((hour * 60 + min) * 60 + sec) * 1000;
            if (negative) {
                offset = -offset;
            }
            SimpleTimeZone z = new SimpleTimeZone(offset, zid);
            return z;
        }
        return null;
    }

    public static TimeZone getCustomTimeZone(int offset) {
        boolean negative = false;
        int tmp = offset;
        if (offset < 0) {
            negative = true;
            tmp = -offset;
        }
        int millis = tmp % 1000;
        int sec = (tmp /= 1000) % 60;
        int min = (tmp /= 60) % 60;
        int hour = tmp / 60;
        String zid = ZoneMeta.getCustomID(hour, min, sec, negative);
        return new SimpleTimeZone(offset, zid);
    }

    private static String getCustomID(int hour, int min, int sec, boolean negative) {
        StringBuffer zid = new StringBuffer("GMT");
        if (hour != 0 || min != 0) {
            if (negative) {
                zid.append('-');
            } else {
                zid.append('+');
            }
            if (hour < 10) {
                zid.append('0');
            }
            zid.append(hour);
            if (min < 10) {
                zid.append('0');
            }
            zid.append(min);
            if (sec != 0) {
                if (sec < 10) {
                    zid.append('0');
                }
                zid.append(sec);
            }
        }
        return zid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOlsonToMetaMap() {
        Map olsonToMeta = null;
        Class clazz = class$com$ibm$icu$impl$ZoneMeta == null ? (class$com$ibm$icu$impl$ZoneMeta = ZoneMeta.class$("com.ibm.icu.impl.ZoneMeta")) : class$com$ibm$icu$impl$ZoneMeta;
        synchronized (clazz) {
            if (OLSON_TO_META_REF != null) {
                olsonToMeta = (HashMap)OLSON_TO_META_REF.get();
            }
            if (olsonToMeta == null) {
                olsonToMeta = ZoneMeta.createOlsonToMetaMap();
                if (olsonToMeta == null) {
                    olsonToMeta = ZoneMeta.createOlsonToMetaMapOld();
                }
                if (olsonToMeta == null) {
                    olsonToMeta = new HashMap();
                }
                OLSON_TO_META_REF = new SoftReference<HashMap>((HashMap)olsonToMeta);
            }
        }
        return olsonToMeta;
    }

    private static Map createOlsonToMetaMap() {
        HashMap olsonToMeta = null;
        UResourceBundle metazoneMappingsBundle = null;
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "metazoneInfo");
            metazoneMappingsBundle = bundle.get("metazoneMappings");
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (metazoneMappingsBundle != null) {
            String[] tzids = ZoneMeta.getAvailableIDs();
            for (int i = 0; i < tzids.length; ++i) {
                if (!tzids[i].equals(ZoneMeta.getCanonicalID(tzids[i]))) continue;
                String tzkey = tzids[i].replace('/', ':');
                try {
                    UResourceBundle zoneBundle = metazoneMappingsBundle.get(tzkey);
                    LinkedList<OlsonToMetaMappingEntry> mzMappings = new LinkedList<OlsonToMetaMappingEntry>();
                    int idx = 0;
                    while (true) {
                        try {
                            UResourceBundle mz = zoneBundle.get("mz" + idx);
                            String[] mzstr = mz.getStringArray();
                            if (mzstr != null && mzstr.length == 3) {
                                OlsonToMetaMappingEntry mzmap = new OlsonToMetaMappingEntry();
                                mzmap.mzid = mzstr[0].intern();
                                mzmap.from = ZoneMeta.parseDate(mzstr[1]);
                                mzmap.to = ZoneMeta.parseDate(mzstr[2]);
                                mzMappings.add(mzmap);
                            }
                        }
                        catch (MissingResourceException nomz) {
                            break;
                        }
                        catch (IllegalArgumentException baddate) {
                            // empty catch block
                        }
                        ++idx;
                    }
                    if (mzMappings.size() == 0) continue;
                    if (olsonToMeta == null) {
                        olsonToMeta = new HashMap();
                    }
                    olsonToMeta.put(tzids[i], mzMappings);
                    continue;
                }
                catch (MissingResourceException noum) {
                    // empty catch block
                }
            }
        }
        return olsonToMeta;
    }

    private static Map createOlsonToMetaMapOld() {
        HashMap olsonToMeta = null;
        UResourceBundle zoneStringsBundle = null;
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "root");
            zoneStringsBundle = bundle.get(ZONE_STRINGS);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (zoneStringsBundle != null) {
            String[] tzids = ZoneMeta.getAvailableIDs();
            for (int i = 0; i < tzids.length; ++i) {
                if (!tzids[i].equals(ZoneMeta.getCanonicalID(tzids[i]))) continue;
                String tzkey = tzids[i].replace('/', ':');
                try {
                    UResourceBundle zoneBundle = zoneStringsBundle.get(tzkey);
                    UResourceBundle useMZ = zoneBundle.get("um");
                    LinkedList<OlsonToMetaMappingEntry> mzMappings = new LinkedList<OlsonToMetaMappingEntry>();
                    int idx = 0;
                    while (true) {
                        try {
                            UResourceBundle mz = useMZ.get("mz" + idx);
                            String[] mzstr = mz.getStringArray();
                            if (mzstr != null && mzstr.length == 3) {
                                OlsonToMetaMappingEntry mzmap = new OlsonToMetaMappingEntry();
                                mzmap.mzid = mzstr[0].intern();
                                mzmap.from = ZoneMeta.parseDate(mzstr[1]);
                                mzmap.to = ZoneMeta.parseDate(mzstr[2]);
                                mzMappings.add(mzmap);
                            }
                        }
                        catch (MissingResourceException nomz) {
                            break;
                        }
                        catch (IllegalArgumentException baddate) {
                            // empty catch block
                        }
                        ++idx;
                    }
                    if (mzMappings.size() == 0) continue;
                    if (olsonToMeta == null) {
                        olsonToMeta = new HashMap();
                    }
                    olsonToMeta.put(tzids[i], mzMappings);
                    continue;
                }
                catch (MissingResourceException noum) {
                    // empty catch block
                }
            }
        }
        return olsonToMeta;
    }

    public static String getMetazoneID(String olsonID, long date) {
        String mzid = null;
        Map olsonToMeta = ZoneMeta.getOlsonToMetaMap();
        List mappings = (List)olsonToMeta.get(olsonID);
        if (mappings != null) {
            for (int i = 0; i < mappings.size(); ++i) {
                OlsonToMetaMappingEntry mzm = (OlsonToMetaMappingEntry)mappings.get(i);
                if (date < mzm.from || date >= mzm.to) continue;
                mzid = mzm.mzid;
                break;
            }
        }
        return mzid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getMetaToOlsonMap() {
        HashMap metaToOlson = null;
        Class clazz = class$com$ibm$icu$impl$ZoneMeta == null ? (class$com$ibm$icu$impl$ZoneMeta = ZoneMeta.class$("com.ibm.icu.impl.ZoneMeta")) : class$com$ibm$icu$impl$ZoneMeta;
        synchronized (clazz) {
            if (META_TO_OLSON_REF != null) {
                metaToOlson = (HashMap)META_TO_OLSON_REF.get();
            }
            if (metaToOlson == null) {
                metaToOlson = new HashMap();
                UResourceBundle metazonesBundle = null;
                try {
                    UResourceBundle supplementalBundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt38b", "supplementalData");
                    UResourceBundle mapTimezonesBundle = supplementalBundle.get("mapTimezones");
                    metazonesBundle = mapTimezonesBundle.get("metazones");
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
                if (metazonesBundle != null) {
                    Enumeration mzenum = metazonesBundle.getKeys();
                    while (mzenum.hasMoreElements()) {
                        int territoryIdx;
                        String mzkey = (String)mzenum.nextElement();
                        if (!mzkey.startsWith("meta:")) continue;
                        String tzid = null;
                        try {
                            tzid = metazonesBundle.getString(mzkey);
                        }
                        catch (MissingResourceException mre) {
                            // empty catch block
                        }
                        if (tzid == null || (territoryIdx = mzkey.lastIndexOf(95)) <= 0) continue;
                        String mzid = mzkey.substring(5, territoryIdx);
                        String territory = mzkey.substring(territoryIdx + 1);
                        LinkedList<MetaToOlsonMappingEntry> mappings = (LinkedList<MetaToOlsonMappingEntry>)metaToOlson.get(mzid);
                        if (mappings == null) {
                            mappings = new LinkedList<MetaToOlsonMappingEntry>();
                            metaToOlson.put(mzid, mappings);
                        }
                        MetaToOlsonMappingEntry olsonmap = new MetaToOlsonMappingEntry();
                        olsonmap.id = tzid;
                        olsonmap.territory = territory;
                        mappings.add(olsonmap);
                    }
                }
                META_TO_OLSON_REF = new SoftReference(metaToOlson);
            }
        }
        return metaToOlson;
    }

    public static String getZoneIdByMetazone(String metazoneID, String region) {
        String tzid = null;
        Map metaToOlson = ZoneMeta.getMetaToOlsonMap();
        List mappings = (List)metaToOlson.get(metazoneID);
        if (mappings != null) {
            for (int i = 0; i < mappings.size(); ++i) {
                MetaToOlsonMappingEntry olsonmap = (MetaToOlsonMappingEntry)mappings.get(i);
                if (olsonmap.territory.equals(region)) {
                    tzid = olsonmap.id;
                    break;
                }
                if (!olsonmap.territory.equals("001")) continue;
                tzid = olsonmap.id;
            }
        }
        return tzid;
    }

    static long parseDate(String text) throws IllegalArgumentException {
        int n;
        int idx;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int min = 0;
        for (idx = 0; idx <= 3; ++idx) {
            n = text.charAt(idx) - 48;
            if (n < 0 || n >= 10) {
                throw new IllegalArgumentException("Bad year");
            }
            year = 10 * year + n;
        }
        for (idx = 5; idx <= 6; ++idx) {
            n = text.charAt(idx) - 48;
            if (n < 0 || n >= 10) {
                throw new IllegalArgumentException("Bad month");
            }
            month = 10 * month + n;
        }
        for (idx = 8; idx <= 9; ++idx) {
            n = text.charAt(idx) - 48;
            if (n < 0 || n >= 10) {
                throw new IllegalArgumentException("Bad day");
            }
            day = 10 * day + n;
        }
        for (idx = 11; idx <= 12; ++idx) {
            n = text.charAt(idx) - 48;
            if (n < 0 || n >= 10) {
                throw new IllegalArgumentException("Bad hour");
            }
            hour = 10 * hour + n;
        }
        for (idx = 14; idx <= 15; ++idx) {
            n = text.charAt(idx) - 48;
            if (n < 0 || n >= 10) {
                throw new IllegalArgumentException("Bad minute");
            }
            min = 10 * min + n;
        }
        long date = Grego.fieldsToDay(year, month - 1, day) * 86400000L + (long)(hour * 3600000) + (long)(min * 60000);
        return date;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MetaToOlsonMappingEntry {
        String id;
        String territory;

        private MetaToOlsonMappingEntry() {
        }
    }

    static class OlsonToMetaMappingEntry {
        String mzid;
        long from;
        long to;

        OlsonToMetaMappingEntry() {
        }
    }
}

